// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** notebook. */
@Fluent
public final class MicrosoftGraphNotebook extends MicrosoftGraphOnenoteEntityHierarchyModel {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphNotebook.class);

    /*
     * Indicates whether this is the user's default notebook. Read-only.
     */
    @JsonProperty(value = "isDefault")
    private Boolean isDefault;

    /*
     * Indicates whether the notebook is shared. If true, the contents of the
     * notebook can be seen by people other than the owner. Read-only.
     */
    @JsonProperty(value = "isShared")
    private Boolean isShared;

    /*
     * notebookLinks
     */
    @JsonProperty(value = "links")
    private MicrosoftGraphNotebookLinks links;

    /*
     * The URL for the sectionGroups navigation property, which returns all the
     * section groups in the notebook. Read-only.
     */
    @JsonProperty(value = "sectionGroupsUrl")
    private String sectionGroupsUrl;

    /*
     * The URL for the sections navigation property, which returns all the
     * sections in the notebook. Read-only.
     */
    @JsonProperty(value = "sectionsUrl")
    private String sectionsUrl;

    /*
     * The userRole property.
     */
    @JsonProperty(value = "userRole")
    private MicrosoftGraphOnenoteUserRole userRole;

    /*
     * The section groups in the notebook. Read-only. Nullable.
     */
    @JsonProperty(value = "sectionGroups")
    private List<MicrosoftGraphSectionGroup> sectionGroups;

    /*
     * The sections in the notebook. Read-only. Nullable.
     */
    @JsonProperty(value = "sections")
    private List<MicrosoftGraphOnenoteSection> sections;

    /*
     * notebook
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the isDefault property: Indicates whether this is the user's default notebook. Read-only.
     *
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: Indicates whether this is the user's default notebook. Read-only.
     *
     * @param isDefault the isDefault value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isShared property: Indicates whether the notebook is shared. If true, the contents of the notebook can be
     * seen by people other than the owner. Read-only.
     *
     * @return the isShared value.
     */
    public Boolean isShared() {
        return this.isShared;
    }

    /**
     * Set the isShared property: Indicates whether the notebook is shared. If true, the contents of the notebook can be
     * seen by people other than the owner. Read-only.
     *
     * @param isShared the isShared value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withIsShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    /**
     * Get the links property: notebookLinks.
     *
     * @return the links value.
     */
    public MicrosoftGraphNotebookLinks links() {
        return this.links;
    }

    /**
     * Set the links property: notebookLinks.
     *
     * @param links the links value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withLinks(MicrosoftGraphNotebookLinks links) {
        this.links = links;
        return this;
    }

    /**
     * Get the sectionGroupsUrl property: The URL for the sectionGroups navigation property, which returns all the
     * section groups in the notebook. Read-only.
     *
     * @return the sectionGroupsUrl value.
     */
    public String sectionGroupsUrl() {
        return this.sectionGroupsUrl;
    }

    /**
     * Set the sectionGroupsUrl property: The URL for the sectionGroups navigation property, which returns all the
     * section groups in the notebook. Read-only.
     *
     * @param sectionGroupsUrl the sectionGroupsUrl value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withSectionGroupsUrl(String sectionGroupsUrl) {
        this.sectionGroupsUrl = sectionGroupsUrl;
        return this;
    }

    /**
     * Get the sectionsUrl property: The URL for the sections navigation property, which returns all the sections in the
     * notebook. Read-only.
     *
     * @return the sectionsUrl value.
     */
    public String sectionsUrl() {
        return this.sectionsUrl;
    }

    /**
     * Set the sectionsUrl property: The URL for the sections navigation property, which returns all the sections in the
     * notebook. Read-only.
     *
     * @param sectionsUrl the sectionsUrl value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withSectionsUrl(String sectionsUrl) {
        this.sectionsUrl = sectionsUrl;
        return this;
    }

    /**
     * Get the userRole property: The userRole property.
     *
     * @return the userRole value.
     */
    public MicrosoftGraphOnenoteUserRole userRole() {
        return this.userRole;
    }

    /**
     * Set the userRole property: The userRole property.
     *
     * @param userRole the userRole value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withUserRole(MicrosoftGraphOnenoteUserRole userRole) {
        this.userRole = userRole;
        return this;
    }

    /**
     * Get the sectionGroups property: The section groups in the notebook. Read-only. Nullable.
     *
     * @return the sectionGroups value.
     */
    public List<MicrosoftGraphSectionGroup> sectionGroups() {
        return this.sectionGroups;
    }

    /**
     * Set the sectionGroups property: The section groups in the notebook. Read-only. Nullable.
     *
     * @param sectionGroups the sectionGroups value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withSectionGroups(List<MicrosoftGraphSectionGroup> sectionGroups) {
        this.sectionGroups = sectionGroups;
        return this;
    }

    /**
     * Get the sections property: The sections in the notebook. Read-only. Nullable.
     *
     * @return the sections value.
     */
    public List<MicrosoftGraphOnenoteSection> sections() {
        return this.sections;
    }

    /**
     * Set the sections property: The sections in the notebook. Read-only. Nullable.
     *
     * @param sections the sections value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withSections(List<MicrosoftGraphOnenoteSection> sections) {
        this.sections = sections;
        return this;
    }

    /**
     * Get the additionalProperties property: notebook.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: notebook.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphNotebook object itself.
     */
    public MicrosoftGraphNotebook withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withSelf(String self) {
        super.withSelf(self);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphNotebook withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (links() != null) {
            links().validate();
        }
        if (sectionGroups() != null) {
            sectionGroups().forEach(e -> e.validate());
        }
        if (sections() != null) {
            sections().forEach(e -> e.validate());
        }
    }
}
