// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** plannerAssignedToTaskBoardTaskFormat. */
@Fluent
public final class MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat extends MicrosoftGraphEntity {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat.class);

    /*
     * plannerOrderHintsByAssignee
     */
    @JsonProperty(value = "orderHintsByAssignee")
    private Map<String, Object> orderHintsByAssignee;

    /*
     * Hint value used to order the task on the AssignedTo view of the Task
     * Board when the task is not assigned to anyone, or if the
     * orderHintsByAssignee dictionary does not provide an order hint for the
     * user the task is assigned to. The format is defined as outlined here.
     */
    @JsonProperty(value = "unassignedOrderHint")
    private String unassignedOrderHint;

    /*
     * plannerAssignedToTaskBoardTaskFormat
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the orderHintsByAssignee property: plannerOrderHintsByAssignee.
     *
     * @return the orderHintsByAssignee value.
     */
    public Map<String, Object> orderHintsByAssignee() {
        return this.orderHintsByAssignee;
    }

    /**
     * Set the orderHintsByAssignee property: plannerOrderHintsByAssignee.
     *
     * @param orderHintsByAssignee the orderHintsByAssignee value to set.
     * @return the MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat withOrderHintsByAssignee(
        Map<String, Object> orderHintsByAssignee) {
        this.orderHintsByAssignee = orderHintsByAssignee;
        return this;
    }

    /**
     * Get the unassignedOrderHint property: Hint value used to order the task on the AssignedTo view of the Task Board
     * when the task is not assigned to anyone, or if the orderHintsByAssignee dictionary does not provide an order hint
     * for the user the task is assigned to. The format is defined as outlined here.
     *
     * @return the unassignedOrderHint value.
     */
    public String unassignedOrderHint() {
        return this.unassignedOrderHint;
    }

    /**
     * Set the unassignedOrderHint property: Hint value used to order the task on the AssignedTo view of the Task Board
     * when the task is not assigned to anyone, or if the orderHintsByAssignee dictionary does not provide an order hint
     * for the user the task is assigned to. The format is defined as outlined here.
     *
     * @param unassignedOrderHint the unassignedOrderHint value to set.
     * @return the MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat withUnassignedOrderHint(String unassignedOrderHint) {
        this.unassignedOrderHint = unassignedOrderHint;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerAssignedToTaskBoardTaskFormat.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerAssignedToTaskBoardTaskFormat.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPlannerAssignedToTaskBoardTaskFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
