// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** plannerBucketTaskBoardTaskFormat. */
@Fluent
public final class MicrosoftGraphPlannerBucketTaskBoardTaskFormat extends MicrosoftGraphEntity {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(MicrosoftGraphPlannerBucketTaskBoardTaskFormat.class);

    /*
     * Hint used to order tasks in the Bucket view of the Task Board. The
     * format is defined as outlined here.
     */
    @JsonProperty(value = "orderHint")
    private String orderHint;

    /*
     * plannerBucketTaskBoardTaskFormat
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the orderHint property: Hint used to order tasks in the Bucket view of the Task Board. The format is defined
     * as outlined here.
     *
     * @return the orderHint value.
     */
    public String orderHint() {
        return this.orderHint;
    }

    /**
     * Set the orderHint property: Hint used to order tasks in the Bucket view of the Task Board. The format is defined
     * as outlined here.
     *
     * @param orderHint the orderHint value to set.
     * @return the MicrosoftGraphPlannerBucketTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerBucketTaskBoardTaskFormat.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerBucketTaskBoardTaskFormat.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerBucketTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPlannerBucketTaskBoardTaskFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
