// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** responseStatus. */
@Fluent
public final class MicrosoftGraphResponseStatus {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphResponseStatus.class);

    /*
     * The response property.
     */
    @JsonProperty(value = "response")
    private MicrosoftGraphResponseType response;

    /*
     * The date and time that the response was returned. It uses ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1,
     * 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "time")
    private OffsetDateTime time;

    /*
     * responseStatus
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the response property: The response property.
     *
     * @return the response value.
     */
    public MicrosoftGraphResponseType response() {
        return this.response;
    }

    /**
     * Set the response property: The response property.
     *
     * @param response the response value to set.
     * @return the MicrosoftGraphResponseStatus object itself.
     */
    public MicrosoftGraphResponseStatus withResponse(MicrosoftGraphResponseType response) {
        this.response = response;
        return this;
    }

    /**
     * Get the time property: The date and time that the response was returned. It uses ISO 8601 format and is always in
     * UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @return the time value.
     */
    public OffsetDateTime time() {
        return this.time;
    }

    /**
     * Set the time property: The date and time that the response was returned. It uses ISO 8601 format and is always in
     * UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'.
     *
     * @param time the time value to set.
     * @return the MicrosoftGraphResponseStatus object itself.
     */
    public MicrosoftGraphResponseStatus withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    /**
     * Get the additionalProperties property: responseStatus.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: responseStatus.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphResponseStatus object itself.
     */
    public MicrosoftGraphResponseStatus withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
