// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** scheduleItem. */
@Fluent
public final class MicrosoftGraphScheduleItem {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphScheduleItem.class);

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "end")
    private MicrosoftGraphDateTimeZone end;

    /*
     * The sensitivity of the corresponding event. True if the event is marked
     * private, false otherwise. Optional.
     */
    @JsonProperty(value = "isPrivate")
    private Boolean isPrivate;

    /*
     * The location where the corresponding event is held or attended from.
     * Optional.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "start")
    private MicrosoftGraphDateTimeZone start;

    /*
     * The status property.
     */
    @JsonProperty(value = "status")
    private MicrosoftGraphFreeBusyStatus status;

    /*
     * The corresponding event's subject line. Optional.
     */
    @JsonProperty(value = "subject")
    private String subject;

    /*
     * scheduleItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the end property: dateTimeTimeZone.
     *
     * @return the end value.
     */
    public MicrosoftGraphDateTimeZone end() {
        return this.end;
    }

    /**
     * Set the end property: dateTimeTimeZone.
     *
     * @param end the end value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withEnd(MicrosoftGraphDateTimeZone end) {
        this.end = end;
        return this;
    }

    /**
     * Get the isPrivate property: The sensitivity of the corresponding event. True if the event is marked private,
     * false otherwise. Optional.
     *
     * @return the isPrivate value.
     */
    public Boolean isPrivate() {
        return this.isPrivate;
    }

    /**
     * Set the isPrivate property: The sensitivity of the corresponding event. True if the event is marked private,
     * false otherwise. Optional.
     *
     * @param isPrivate the isPrivate value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
        return this;
    }

    /**
     * Get the location property: The location where the corresponding event is held or attended from. Optional.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location where the corresponding event is held or attended from. Optional.
     *
     * @param location the location value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the start property: dateTimeTimeZone.
     *
     * @return the start value.
     */
    public MicrosoftGraphDateTimeZone start() {
        return this.start;
    }

    /**
     * Set the start property: dateTimeTimeZone.
     *
     * @param start the start value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withStart(MicrosoftGraphDateTimeZone start) {
        this.start = start;
        return this;
    }

    /**
     * Get the status property: The status property.
     *
     * @return the status value.
     */
    public MicrosoftGraphFreeBusyStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The status property.
     *
     * @param status the status value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withStatus(MicrosoftGraphFreeBusyStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the subject property: The corresponding event's subject line. Optional.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set the subject property: The corresponding event's subject line. Optional.
     *
     * @param subject the subject value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get the additionalProperties property: scheduleItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: scheduleItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphScheduleItem object itself.
     */
    public MicrosoftGraphScheduleItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (end() != null) {
            end().validate();
        }
        if (start() != null) {
            start().validate();
        }
    }
}
