// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookCommentReply. */
@Fluent
public final class MicrosoftGraphWorkbookCommentReply extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphWorkbookCommentReply.class);

    /*
     * The content of a comment reply.
     */
    @JsonProperty(value = "content")
    private String content;

    /*
     * Indicates the type for the comment reply.
     */
    @JsonProperty(value = "contentType")
    private String contentType;

    /*
     * workbookCommentReply
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the content property: The content of a comment reply.
     *
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of a comment reply.
     *
     * @param content the content value to set.
     * @return the MicrosoftGraphWorkbookCommentReply object itself.
     */
    public MicrosoftGraphWorkbookCommentReply withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the contentType property: Indicates the type for the comment reply.
     *
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Indicates the type for the comment reply.
     *
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphWorkbookCommentReply object itself.
     */
    public MicrosoftGraphWorkbookCommentReply withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookCommentReply.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookCommentReply.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookCommentReply object itself.
     */
    public MicrosoftGraphWorkbookCommentReply withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookCommentReply withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
