// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersSettingsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftPreferencesInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersSettingsSelect;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in UsersSettingsClient. */
public final class UsersSettingsClientImpl implements UsersSettingsClient {
    private final ClientLogger logger = new ClientLogger(UsersSettingsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final UsersSettingsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of UsersSettingsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    UsersSettingsClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy.create(UsersSettingsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientUsersSettings to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface UsersSettingsService {
        @Headers({"Content-Type: application/json"})
        @Get("/users/{user-id}/settings/shiftPreferences")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferences(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/users/{user-id}/settings/shiftPreferences")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateShiftPreferences(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @BodyParam("application/json") MicrosoftGraphShiftPreferencesInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/users/{user-id}/settings/shiftPreferences")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteShiftPreferences(
            @HostParam("$host") String endpoint,
            @PathParam("user-id") String userId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferencesWithResponseAsync(
        String userId, List<UsersSettingsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getShiftPreferences(
                            this.client.getEndpoint(), userId, selectConverted, expandConverted, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphShiftPreferencesInner>> getShiftPreferencesWithResponseAsync(
        String userId, List<UsersSettingsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getShiftPreferences(this.client.getEndpoint(), userId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesAsync(
        String userId, List<UsersSettingsSelect> select, List<String> expand) {
        return getShiftPreferencesWithResponseAsync(userId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphShiftPreferencesInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesAsync(String userId) {
        final List<UsersSettingsSelect> select = null;
        final List<String> expand = null;
        return getShiftPreferencesWithResponseAsync(userId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphShiftPreferencesInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphShiftPreferencesInner getShiftPreferences(String userId) {
        final List<UsersSettingsSelect> select = null;
        final List<String> expand = null;
        return getShiftPreferencesAsync(userId, select, expand).block();
    }

    /**
     * Get shiftPreferences from users.
     *
     * @param userId key: id of user.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return shiftPreferences from users.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphShiftPreferencesInner> getShiftPreferencesWithResponse(
        String userId, List<UsersSettingsSelect> select, List<String> expand, Context context) {
        return getShiftPreferencesWithResponseAsync(userId, select, expand, context).block();
    }

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateShiftPreferencesWithResponseAsync(
        String userId, MicrosoftGraphShiftPreferencesInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.updateShiftPreferences(this.client.getEndpoint(), userId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateShiftPreferencesWithResponseAsync(
        String userId, MicrosoftGraphShiftPreferencesInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateShiftPreferences(this.client.getEndpoint(), userId, body, accept, context);
    }

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateShiftPreferencesAsync(String userId, MicrosoftGraphShiftPreferencesInner body) {
        return updateShiftPreferencesWithResponseAsync(userId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateShiftPreferences(String userId, MicrosoftGraphShiftPreferencesInner body) {
        updateShiftPreferencesAsync(userId, body).block();
    }

    /**
     * Update the navigation property shiftPreferences in users.
     *
     * @param userId key: id of user.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateShiftPreferencesWithResponse(
        String userId, MicrosoftGraphShiftPreferencesInner body, Context context) {
        return updateShiftPreferencesWithResponseAsync(userId, body, context).block();
    }

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteShiftPreferencesWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.deleteShiftPreferences(this.client.getEndpoint(), userId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteShiftPreferencesWithResponseAsync(
        String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteShiftPreferences(this.client.getEndpoint(), userId, ifMatch, accept, context);
    }

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteShiftPreferencesAsync(String userId, String ifMatch) {
        return deleteShiftPreferencesWithResponseAsync(userId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteShiftPreferencesAsync(String userId) {
        final String ifMatch = null;
        return deleteShiftPreferencesWithResponseAsync(userId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteShiftPreferences(String userId) {
        final String ifMatch = null;
        deleteShiftPreferencesAsync(userId, ifMatch).block();
    }

    /**
     * Delete navigation property shiftPreferences for users.
     *
     * @param userId key: id of user.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteShiftPreferencesWithResponse(String userId, String ifMatch, Context context) {
        return deleteShiftPreferencesWithResponseAsync(userId, ifMatch, context).block();
    }
}
