// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ErrorError model. */
@Fluent
public final class ErrorError {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ErrorError.class);

    /*
     * Brief error code
     */
    @JsonProperty(value = "code")
    private String code;

    /*
     * Longer message explaining the details of the error
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the code property: Brief error code.
     *
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: Brief error code.
     *
     * @param code the code value to set.
     * @return the ErrorError object itself.
     */
    public ErrorError withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Longer message explaining the details of the error.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Longer message explaining the details of the error.
     *
     * @param message the message value to set.
     * @return the ErrorError object itself.
     */
    public ErrorError withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
