/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.fluent.AutomanageClient;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientBuilder;
import com.azure.resourcemanager.automanage.implementation.BestPracticesImpl;
import com.azure.resourcemanager.automanage.implementation.BestPracticesVersionsImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileAssignmentsImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileHciAssignmentsImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileHcrpAssignmentsImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfilesImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfilesVersionsImpl;
import com.azure.resourcemanager.automanage.implementation.HciReportsImpl;
import com.azure.resourcemanager.automanage.implementation.HcrpReportsImpl;
import com.azure.resourcemanager.automanage.implementation.OperationsImpl;
import com.azure.resourcemanager.automanage.implementation.ReportsImpl;
import com.azure.resourcemanager.automanage.implementation.ServicePrincipalsImpl;
import com.azure.resourcemanager.automanage.models.BestPractices;
import com.azure.resourcemanager.automanage.models.BestPracticesVersions;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignments;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileHciAssignments;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileHcrpAssignments;
import com.azure.resourcemanager.automanage.models.ConfigurationProfiles;
import com.azure.resourcemanager.automanage.models.ConfigurationProfilesVersions;
import com.azure.resourcemanager.automanage.models.HciReports;
import com.azure.resourcemanager.automanage.models.HcrpReports;
import com.azure.resourcemanager.automanage.models.Operations;
import com.azure.resourcemanager.automanage.models.Reports;
import com.azure.resourcemanager.automanage.models.ServicePrincipals;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class AutomanageManager {
    private BestPractices bestPractices;
    private BestPracticesVersions bestPracticesVersions;
    private ConfigurationProfiles configurationProfiles;
    private ConfigurationProfilesVersions configurationProfilesVersions;
    private ConfigurationProfileAssignments configurationProfileAssignments;
    private Operations operations;
    private Reports reports;
    private ServicePrincipals servicePrincipals;
    private ConfigurationProfileHcrpAssignments configurationProfileHcrpAssignments;
    private HcrpReports hcrpReports;
    private ConfigurationProfileHciAssignments configurationProfileHciAssignments;
    private HciReports hciReports;
    private final AutomanageClient clientObject;

    private AutomanageManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new AutomanageClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static AutomanageManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return AutomanageManager.configure().authenticate(credential, profile);
    }

    public static AutomanageManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AutomanageManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public BestPractices bestPractices() {
        if (this.bestPractices == null) {
            this.bestPractices = new BestPracticesImpl(this.clientObject.getBestPractices(), this);
        }
        return this.bestPractices;
    }

    public BestPracticesVersions bestPracticesVersions() {
        if (this.bestPracticesVersions == null) {
            this.bestPracticesVersions = new BestPracticesVersionsImpl(this.clientObject.getBestPracticesVersions(), this);
        }
        return this.bestPracticesVersions;
    }

    public ConfigurationProfiles configurationProfiles() {
        if (this.configurationProfiles == null) {
            this.configurationProfiles = new ConfigurationProfilesImpl(this.clientObject.getConfigurationProfiles(), this);
        }
        return this.configurationProfiles;
    }

    public ConfigurationProfilesVersions configurationProfilesVersions() {
        if (this.configurationProfilesVersions == null) {
            this.configurationProfilesVersions = new ConfigurationProfilesVersionsImpl(this.clientObject.getConfigurationProfilesVersions(), this);
        }
        return this.configurationProfilesVersions;
    }

    public ConfigurationProfileAssignments configurationProfileAssignments() {
        if (this.configurationProfileAssignments == null) {
            this.configurationProfileAssignments = new ConfigurationProfileAssignmentsImpl(this.clientObject.getConfigurationProfileAssignments(), this);
        }
        return this.configurationProfileAssignments;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Reports reports() {
        if (this.reports == null) {
            this.reports = new ReportsImpl(this.clientObject.getReports(), this);
        }
        return this.reports;
    }

    public ServicePrincipals servicePrincipals() {
        if (this.servicePrincipals == null) {
            this.servicePrincipals = new ServicePrincipalsImpl(this.clientObject.getServicePrincipals(), this);
        }
        return this.servicePrincipals;
    }

    public ConfigurationProfileHcrpAssignments configurationProfileHcrpAssignments() {
        if (this.configurationProfileHcrpAssignments == null) {
            this.configurationProfileHcrpAssignments = new ConfigurationProfileHcrpAssignmentsImpl(this.clientObject.getConfigurationProfileHcrpAssignments(), this);
        }
        return this.configurationProfileHcrpAssignments;
    }

    public HcrpReports hcrpReports() {
        if (this.hcrpReports == null) {
            this.hcrpReports = new HcrpReportsImpl(this.clientObject.getHcrpReports(), this);
        }
        return this.hcrpReports;
    }

    public ConfigurationProfileHciAssignments configurationProfileHciAssignments() {
        if (this.configurationProfileHciAssignments == null) {
            this.configurationProfileHciAssignments = new ConfigurationProfileHciAssignmentsImpl(this.clientObject.getConfigurationProfileHciAssignments(), this);
        }
        return this.configurationProfileHciAssignments;
    }

    public HciReports hciReports() {
        if (this.hciReports == null) {
            this.hciReports = new HciReportsImpl(this.clientObject.getHciReports(), this);
        }
        return this.hciReports;
    }

    public AutomanageClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public AutomanageManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.automanage").append("/").append("1.0.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new AutomanageManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

