/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileProperties;
import java.io.IOException;
import java.util.Map;

public final class ConfigurationProfileInner
extends Resource {
    private ConfigurationProfileProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ConfigurationProfileProperties properties() {
        return this.properties;
    }

    public ConfigurationProfileInner withProperties(ConfigurationProfileProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ConfigurationProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ConfigurationProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationProfileInner)((Object)jsonReader.readObject(reader -> {
            ConfigurationProfileInner deserializedConfigurationProfileInner = new ConfigurationProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConfigurationProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConfigurationProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConfigurationProfileInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedConfigurationProfileInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConfigurationProfileInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigurationProfileInner.properties = ConfigurationProfileProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedConfigurationProfileInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationProfileInner;
        }));
    }
}

