/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.automanage.fluent.AutomanageClient;
import com.azure.resourcemanager.automanage.fluent.BestPracticesClient;
import com.azure.resourcemanager.automanage.fluent.BestPracticesVersionsClient;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileHciAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileHcrpAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfilesClient;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfilesVersionsClient;
import com.azure.resourcemanager.automanage.fluent.HciReportsClient;
import com.azure.resourcemanager.automanage.fluent.HcrpReportsClient;
import com.azure.resourcemanager.automanage.fluent.OperationsClient;
import com.azure.resourcemanager.automanage.fluent.ReportsClient;
import com.azure.resourcemanager.automanage.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientBuilder;
import com.azure.resourcemanager.automanage.implementation.BestPracticesClientImpl;
import com.azure.resourcemanager.automanage.implementation.BestPracticesVersionsClientImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileAssignmentsClientImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileHciAssignmentsClientImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileHcrpAssignmentsClientImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfilesClientImpl;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfilesVersionsClientImpl;
import com.azure.resourcemanager.automanage.implementation.HciReportsClientImpl;
import com.azure.resourcemanager.automanage.implementation.HcrpReportsClientImpl;
import com.azure.resourcemanager.automanage.implementation.OperationsClientImpl;
import com.azure.resourcemanager.automanage.implementation.ReportsClientImpl;
import com.azure.resourcemanager.automanage.implementation.ServicePrincipalsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AutomanageClientBuilder.class)
public final class AutomanageClientImpl
implements AutomanageClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final BestPracticesClient bestPractices;
    private final BestPracticesVersionsClient bestPracticesVersions;
    private final ConfigurationProfilesClient configurationProfiles;
    private final ConfigurationProfilesVersionsClient configurationProfilesVersions;
    private final ConfigurationProfileAssignmentsClient configurationProfileAssignments;
    private final OperationsClient operations;
    private final ReportsClient reports;
    private final ServicePrincipalsClient servicePrincipals;
    private final ConfigurationProfileHcrpAssignmentsClient configurationProfileHcrpAssignments;
    private final HcrpReportsClient hcrpReports;
    private final ConfigurationProfileHciAssignmentsClient configurationProfileHciAssignments;
    private final HciReportsClient hciReports;
    private static final ClientLogger LOGGER = new ClientLogger(AutomanageClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public BestPracticesClient getBestPractices() {
        return this.bestPractices;
    }

    @Override
    public BestPracticesVersionsClient getBestPracticesVersions() {
        return this.bestPracticesVersions;
    }

    @Override
    public ConfigurationProfilesClient getConfigurationProfiles() {
        return this.configurationProfiles;
    }

    @Override
    public ConfigurationProfilesVersionsClient getConfigurationProfilesVersions() {
        return this.configurationProfilesVersions;
    }

    @Override
    public ConfigurationProfileAssignmentsClient getConfigurationProfileAssignments() {
        return this.configurationProfileAssignments;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ReportsClient getReports() {
        return this.reports;
    }

    @Override
    public ServicePrincipalsClient getServicePrincipals() {
        return this.servicePrincipals;
    }

    @Override
    public ConfigurationProfileHcrpAssignmentsClient getConfigurationProfileHcrpAssignments() {
        return this.configurationProfileHcrpAssignments;
    }

    @Override
    public HcrpReportsClient getHcrpReports() {
        return this.hcrpReports;
    }

    @Override
    public ConfigurationProfileHciAssignmentsClient getConfigurationProfileHciAssignments() {
        return this.configurationProfileHciAssignments;
    }

    @Override
    public HciReportsClient getHciReports() {
        return this.hciReports;
    }

    AutomanageClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2022-05-04";
        this.bestPractices = new BestPracticesClientImpl(this);
        this.bestPracticesVersions = new BestPracticesVersionsClientImpl(this);
        this.configurationProfiles = new ConfigurationProfilesClientImpl(this);
        this.configurationProfilesVersions = new ConfigurationProfilesVersionsClientImpl(this);
        this.configurationProfileAssignments = new ConfigurationProfileAssignmentsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.reports = new ReportsClientImpl(this);
        this.servicePrincipals = new ServicePrincipalsClientImpl(this);
        this.configurationProfileHcrpAssignments = new ConfigurationProfileHcrpAssignmentsClientImpl(this);
        this.hcrpReports = new HcrpReportsClientImpl(this);
        this.configurationProfileHciAssignments = new ConfigurationProfileHciAssignmentsClientImpl(this);
        this.hciReports = new HciReportsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

