/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automanage.fluent.BestPracticesClient;
import com.azure.resourcemanager.automanage.fluent.models.BestPracticeInner;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientImpl;
import com.azure.resourcemanager.automanage.models.BestPracticeList;
import reactor.core.publisher.Mono;

public final class BestPracticesClientImpl
implements BestPracticesClient {
    private final BestPracticesService service;
    private final AutomanageClientImpl client;

    BestPracticesClientImpl(AutomanageClientImpl client) {
        this.service = (BestPracticesService)RestProxy.create(BestPracticesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BestPracticeInner>> getWithResponseAsync(String bestPracticeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (bestPracticeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bestPracticeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), bestPracticeName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BestPracticeInner>> getWithResponseAsync(String bestPracticeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (bestPracticeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bestPracticeName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), bestPracticeName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BestPracticeInner> getAsync(String bestPracticeName) {
        return this.getWithResponseAsync(bestPracticeName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BestPracticeInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BestPracticeInner> getWithResponse(String bestPracticeName, Context context) {
        return (Response)this.getWithResponseAsync(bestPracticeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BestPracticeInner get(String bestPracticeName) {
        return (BestPracticeInner)((Object)this.getWithResponse(bestPracticeName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BestPracticeInner>> listByTenantSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTenant(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BestPracticeList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BestPracticeInner>> listByTenantSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTenant(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BestPracticeList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BestPracticeInner> listByTenantAsync() {
        return new PagedFlux(() -> this.listByTenantSinglePageAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BestPracticeInner> listByTenantAsync(Context context) {
        return new PagedFlux(() -> this.listByTenantSinglePageAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BestPracticeInner> listByTenant() {
        return new PagedIterable(this.listByTenantAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BestPracticeInner> listByTenant(Context context) {
        return new PagedIterable(this.listByTenantAsync(context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomanageClientBest")
    public static interface BestPracticesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Automanage/bestPractices/{bestPracticeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BestPracticeInner>> get(@HostParam(value="$host") String var1, @PathParam(value="bestPracticeName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Automanage/bestPractices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BestPracticeList>> listByTenant(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

