/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.BestPracticesVersionsClient;
import com.azure.resourcemanager.automanage.fluent.models.BestPracticeInner;
import com.azure.resourcemanager.automanage.implementation.BestPracticeImpl;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.BestPractice;
import com.azure.resourcemanager.automanage.models.BestPracticesVersions;

public final class BestPracticesVersionsImpl
implements BestPracticesVersions {
    private static final ClientLogger LOGGER = new ClientLogger(BestPracticesVersionsImpl.class);
    private final BestPracticesVersionsClient innerClient;
    private final AutomanageManager serviceManager;

    public BestPracticesVersionsImpl(BestPracticesVersionsClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BestPractice> getWithResponse(String bestPracticeName, String versionName, Context context) {
        Response<BestPracticeInner> inner = this.serviceClient().getWithResponse(bestPracticeName, versionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BestPracticeImpl((BestPracticeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BestPractice get(String bestPracticeName, String versionName) {
        BestPracticeInner inner = this.serviceClient().get(bestPracticeName, versionName);
        if (inner != null) {
            return new BestPracticeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<BestPractice> listByTenant(String bestPracticeName) {
        PagedIterable<BestPracticeInner> inner = this.serviceClient().listByTenant(bestPracticeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BestPracticeImpl((BestPracticeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BestPractice> listByTenant(String bestPracticeName, Context context) {
        PagedIterable<BestPracticeInner> inner = this.serviceClient().listByTenant(bestPracticeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BestPracticeImpl((BestPracticeInner)((Object)inner1), this.manager()));
    }

    private BestPracticesVersionsClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }
}

