/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileAssignmentInner;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignment;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignmentProperties;

public final class ConfigurationProfileAssignmentImpl
implements ConfigurationProfileAssignment,
ConfigurationProfileAssignment.Definition,
ConfigurationProfileAssignment.Update {
    private ConfigurationProfileAssignmentInner innerObject;
    private final AutomanageManager serviceManager;
    private String configurationProfileAssignmentName;
    private String resourceGroupName;
    private String vmName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ConfigurationProfileAssignmentProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String managedBy() {
        return this.innerModel().managedBy();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConfigurationProfileAssignmentInner innerModel() {
        return this.innerObject;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationProfileAssignmentImpl withExistingVirtualMachine(String resourceGroupName, String vmName) {
        this.resourceGroupName = resourceGroupName;
        this.vmName = vmName;
        return this;
    }

    @Override
    public ConfigurationProfileAssignment create() {
        this.innerObject = (ConfigurationProfileAssignmentInner)((Object)this.serviceManager.serviceClient().getConfigurationProfileAssignments().createOrUpdateWithResponse(this.configurationProfileAssignmentName, this.resourceGroupName, this.vmName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationProfileAssignment create(Context context) {
        this.innerObject = (ConfigurationProfileAssignmentInner)((Object)this.serviceManager.serviceClient().getConfigurationProfileAssignments().createOrUpdateWithResponse(this.configurationProfileAssignmentName, this.resourceGroupName, this.vmName, this.innerModel(), context).getValue());
        return this;
    }

    ConfigurationProfileAssignmentImpl(String name, AutomanageManager serviceManager) {
        this.innerObject = new ConfigurationProfileAssignmentInner();
        this.serviceManager = serviceManager;
        this.configurationProfileAssignmentName = name;
    }

    @Override
    public ConfigurationProfileAssignmentImpl update() {
        return this;
    }

    @Override
    public ConfigurationProfileAssignment apply() {
        this.innerObject = (ConfigurationProfileAssignmentInner)((Object)this.serviceManager.serviceClient().getConfigurationProfileAssignments().createOrUpdateWithResponse(this.configurationProfileAssignmentName, this.resourceGroupName, this.vmName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationProfileAssignment apply(Context context) {
        this.innerObject = (ConfigurationProfileAssignmentInner)((Object)this.serviceManager.serviceClient().getConfigurationProfileAssignments().createOrUpdateWithResponse(this.configurationProfileAssignmentName, this.resourceGroupName, this.vmName, this.innerModel(), context).getValue());
        return this;
    }

    ConfigurationProfileAssignmentImpl(ConfigurationProfileAssignmentInner innerObject, AutomanageManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.configurationProfileAssignmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurationProfileAssignments");
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.vmName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualMachines");
    }

    @Override
    public ConfigurationProfileAssignment refresh() {
        this.innerObject = (ConfigurationProfileAssignmentInner)((Object)this.serviceManager.serviceClient().getConfigurationProfileAssignments().getWithResponse(this.resourceGroupName, this.configurationProfileAssignmentName, this.vmName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationProfileAssignment refresh(Context context) {
        this.innerObject = (ConfigurationProfileAssignmentInner)((Object)this.serviceManager.serviceClient().getConfigurationProfileAssignments().getWithResponse(this.resourceGroupName, this.configurationProfileAssignmentName, this.vmName, context).getValue());
        return this;
    }

    @Override
    public ConfigurationProfileAssignmentImpl withProperties(ConfigurationProfileAssignmentProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

