/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileAssignmentInner;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientImpl;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignmentList;
import reactor.core.publisher.Mono;

public final class ConfigurationProfileAssignmentsClientImpl
implements ConfigurationProfileAssignmentsClient {
    private final ConfigurationProfileAssignmentsService service;
    private final AutomanageClientImpl client;

    ConfigurationProfileAssignmentsClientImpl(AutomanageClientImpl client) {
        this.service = (ConfigurationProfileAssignmentsService)RestProxy.create(ConfigurationProfileAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> createOrUpdateWithResponseAsync(String configurationProfileAssignmentName, String resourceGroupName, String vmName, ConfigurationProfileAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), configurationProfileAssignmentName, this.client.getSubscriptionId(), resourceGroupName, vmName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> createOrUpdateWithResponseAsync(String configurationProfileAssignmentName, String resourceGroupName, String vmName, ConfigurationProfileAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), configurationProfileAssignmentName, this.client.getSubscriptionId(), resourceGroupName, vmName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationProfileAssignmentInner> createOrUpdateAsync(String configurationProfileAssignmentName, String resourceGroupName, String vmName, ConfigurationProfileAssignmentInner parameters) {
        return this.createOrUpdateWithResponseAsync(configurationProfileAssignmentName, resourceGroupName, vmName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConfigurationProfileAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationProfileAssignmentInner> createOrUpdateWithResponse(String configurationProfileAssignmentName, String resourceGroupName, String vmName, ConfigurationProfileAssignmentInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(configurationProfileAssignmentName, resourceGroupName, vmName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationProfileAssignmentInner createOrUpdate(String configurationProfileAssignmentName, String resourceGroupName, String vmName, ConfigurationProfileAssignmentInner parameters) {
        return (ConfigurationProfileAssignmentInner)((Object)this.createOrUpdateWithResponse(configurationProfileAssignmentName, resourceGroupName, vmName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> getWithResponseAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, configurationProfileAssignmentName, this.client.getSubscriptionId(), vmName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> getWithResponseAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, configurationProfileAssignmentName, this.client.getSubscriptionId(), vmName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationProfileAssignmentInner> getAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        return this.getWithResponseAsync(resourceGroupName, configurationProfileAssignmentName, vmName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConfigurationProfileAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationProfileAssignmentInner> getWithResponse(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, configurationProfileAssignmentName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationProfileAssignmentInner get(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        return (ConfigurationProfileAssignmentInner)((Object)this.getWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, configurationProfileAssignmentName, this.client.getSubscriptionId(), vmName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, configurationProfileAssignmentName, this.client.getSubscriptionId(), vmName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        return this.deleteWithResponseAsync(resourceGroupName, configurationProfileAssignmentName, vmName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, configurationProfileAssignmentName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        this.deleteWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByVirtualMachinesSinglePageAsync(String resourceGroupName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachines(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vmName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByVirtualMachinesSinglePageAsync(String resourceGroupName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByVirtualMachines(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vmName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByVirtualMachinesAsync(String resourceGroupName, String vmName) {
        return new PagedFlux(() -> this.listByVirtualMachinesSinglePageAsync(resourceGroupName, vmName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByVirtualMachinesAsync(String resourceGroupName, String vmName, Context context) {
        return new PagedFlux(() -> this.listByVirtualMachinesSinglePageAsync(resourceGroupName, vmName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByVirtualMachines(String resourceGroupName, String vmName) {
        return new PagedIterable(this.listByVirtualMachinesAsync(resourceGroupName, vmName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByVirtualMachines(String resourceGroupName, String vmName, Context context) {
        return new PagedIterable(this.listByVirtualMachinesAsync(resourceGroupName, vmName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByMachineNameSinglePageAsync(String resourceGroupName, String machineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByMachineName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, machineName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByMachineNameSinglePageAsync(String resourceGroupName, String machineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByMachineName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, machineName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByMachineNameAsync(String resourceGroupName, String machineName) {
        return new PagedFlux(() -> this.listByMachineNameSinglePageAsync(resourceGroupName, machineName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByMachineNameAsync(String resourceGroupName, String machineName, Context context) {
        return new PagedFlux(() -> this.listByMachineNameSinglePageAsync(resourceGroupName, machineName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByMachineName(String resourceGroupName, String machineName) {
        return new PagedIterable(this.listByMachineNameAsync(resourceGroupName, machineName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByMachineName(String resourceGroupName, String machineName, Context context) {
        return new PagedIterable(this.listByMachineNameAsync(resourceGroupName, machineName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByClusterNameSinglePageAsync(String resourceGroupName, String clusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByClusterName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileAssignmentInner>> listByClusterNameSinglePageAsync(String resourceGroupName, String clusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByClusterName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileAssignmentList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByClusterNameAsync(String resourceGroupName, String clusterName) {
        return new PagedFlux(() -> this.listByClusterNameSinglePageAsync(resourceGroupName, clusterName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileAssignmentInner> listByClusterNameAsync(String resourceGroupName, String clusterName, Context context) {
        return new PagedFlux(() -> this.listByClusterNameSinglePageAsync(resourceGroupName, clusterName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByClusterName(String resourceGroupName, String clusterName) {
        return new PagedIterable(this.listByClusterNameAsync(resourceGroupName, clusterName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileAssignmentInner> listByClusterName(String resourceGroupName, String clusterName, Context context) {
        return new PagedIterable(this.listByClusterNameAsync(resourceGroupName, clusterName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomanageClientConf")
    public static interface ConfigurationProfileAssignmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="configurationProfileAssignmentName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vmName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConfigurationProfileAssignmentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="configurationProfileAssignmentName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="vmName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="configurationProfileAssignmentName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="vmName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentList>> listByVirtualMachines(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vmName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfileAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentList>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Automanage/configurationProfileAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentList>> listByMachineName(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="machineName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHci/clusters/{clusterName}/providers/Microsoft.Automanage/configurationProfileAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentList>> listByClusterName(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

