/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileAssignmentInner;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileAssignmentImpl;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignment;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignments;

public final class ConfigurationProfileAssignmentsImpl
implements ConfigurationProfileAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationProfileAssignmentsImpl.class);
    private final ConfigurationProfileAssignmentsClient innerClient;
    private final AutomanageManager serviceManager;

    public ConfigurationProfileAssignmentsImpl(ConfigurationProfileAssignmentsClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConfigurationProfileAssignment> getWithResponse(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        Response<ConfigurationProfileAssignmentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationProfileAssignment get(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        ConfigurationProfileAssignmentInner inner = this.serviceClient().get(resourceGroupName, configurationProfileAssignmentName, vmName);
        if (inner != null) {
            return new ConfigurationProfileAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, context);
    }

    @Override
    public void delete(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        this.serviceClient().delete(resourceGroupName, configurationProfileAssignmentName, vmName);
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByVirtualMachines(String resourceGroupName, String vmName) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByVirtualMachines(resourceGroupName, vmName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByVirtualMachines(String resourceGroupName, String vmName, Context context) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByVirtualMachines(resourceGroupName, vmName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> list() {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> list(Context context) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByMachineName(String resourceGroupName, String machineName) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByMachineName(resourceGroupName, machineName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByMachineName(String resourceGroupName, String machineName, Context context) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByMachineName(resourceGroupName, machineName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByClusterName(String resourceGroupName, String clusterName) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByClusterName(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfileAssignment> listByClusterName(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<ConfigurationProfileAssignmentInner> inner = this.serviceClient().listByClusterName(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public ConfigurationProfileAssignment getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfileAssignments");
        if (configurationProfileAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfileAssignments'.", id)));
        }
        String vmName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (vmName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        return (ConfigurationProfileAssignment)this.getWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, Context.NONE).getValue();
    }

    @Override
    public Response<ConfigurationProfileAssignment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfileAssignments");
        if (configurationProfileAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfileAssignments'.", id)));
        }
        String vmName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (vmName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        return this.getWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfileAssignments");
        if (configurationProfileAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfileAssignments'.", id)));
        }
        String vmName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (vmName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileAssignmentName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfileAssignments");
        if (configurationProfileAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfileAssignments'.", id)));
        }
        String vmName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (vmName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, configurationProfileAssignmentName, vmName, context);
    }

    private ConfigurationProfileAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationProfileAssignmentImpl define(String name) {
        return new ConfigurationProfileAssignmentImpl(name, this.manager());
    }
}

