/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileHciAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileAssignmentInner;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileAssignmentImpl;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileAssignment;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileHciAssignments;

public final class ConfigurationProfileHciAssignmentsImpl
implements ConfigurationProfileHciAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationProfileHciAssignmentsImpl.class);
    private final ConfigurationProfileHciAssignmentsClient innerClient;
    private final AutomanageManager serviceManager;

    public ConfigurationProfileHciAssignmentsImpl(ConfigurationProfileHciAssignmentsClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConfigurationProfileAssignment> createOrUpdateWithResponse(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters, Context context) {
        Response<ConfigurationProfileAssignmentInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, clusterName, configurationProfileAssignmentName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationProfileAssignment createOrUpdate(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters) {
        ConfigurationProfileAssignmentInner inner = this.serviceClient().createOrUpdate(resourceGroupName, clusterName, configurationProfileAssignmentName, parameters);
        if (inner != null) {
            return new ConfigurationProfileAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ConfigurationProfileAssignment> getWithResponse(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, Context context) {
        Response<ConfigurationProfileAssignmentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, configurationProfileAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationProfileAssignmentImpl((ConfigurationProfileAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationProfileAssignment get(String resourceGroupName, String clusterName, String configurationProfileAssignmentName) {
        ConfigurationProfileAssignmentInner inner = this.serviceClient().get(resourceGroupName, clusterName, configurationProfileAssignmentName);
        if (inner != null) {
            return new ConfigurationProfileAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, clusterName, configurationProfileAssignmentName, context);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String configurationProfileAssignmentName) {
        this.serviceClient().delete(resourceGroupName, clusterName, configurationProfileAssignmentName);
    }

    private ConfigurationProfileHciAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }
}

