/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfileHcrpAssignmentsClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileAssignmentInner;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientImpl;
import reactor.core.publisher.Mono;

public final class ConfigurationProfileHcrpAssignmentsClientImpl
implements ConfigurationProfileHcrpAssignmentsClient {
    private final ConfigurationProfileHcrpAssignmentsService service;
    private final AutomanageClientImpl client;

    ConfigurationProfileHcrpAssignmentsClientImpl(AutomanageClientImpl client) {
        this.service = (ConfigurationProfileHcrpAssignmentsService)RestProxy.create(ConfigurationProfileHcrpAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, machineName, configurationProfileAssignmentName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, machineName, configurationProfileAssignmentName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationProfileAssignmentInner> createOrUpdateAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, machineName, configurationProfileAssignmentName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConfigurationProfileAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationProfileAssignmentInner> createOrUpdateWithResponse(String resourceGroupName, String machineName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, machineName, configurationProfileAssignmentName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationProfileAssignmentInner createOrUpdate(String resourceGroupName, String machineName, String configurationProfileAssignmentName, ConfigurationProfileAssignmentInner parameters) {
        return (ConfigurationProfileAssignmentInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, machineName, configurationProfileAssignmentName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> getWithResponseAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), machineName, configurationProfileAssignmentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileAssignmentInner>> getWithResponseAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), machineName, configurationProfileAssignmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationProfileAssignmentInner> getAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName) {
        return this.getWithResponseAsync(resourceGroupName, machineName, configurationProfileAssignmentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConfigurationProfileAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationProfileAssignmentInner> getWithResponse(String resourceGroupName, String machineName, String configurationProfileAssignmentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, machineName, configurationProfileAssignmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationProfileAssignmentInner get(String resourceGroupName, String machineName, String configurationProfileAssignmentName) {
        return (ConfigurationProfileAssignmentInner)((Object)this.getWithResponse(resourceGroupName, machineName, configurationProfileAssignmentName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), machineName, configurationProfileAssignmentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (machineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter machineName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), machineName, configurationProfileAssignmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String machineName, String configurationProfileAssignmentName) {
        return this.deleteWithResponseAsync(resourceGroupName, machineName, configurationProfileAssignmentName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String machineName, String configurationProfileAssignmentName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, machineName, configurationProfileAssignmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String machineName, String configurationProfileAssignmentName) {
        this.deleteWithResponse(resourceGroupName, machineName, configurationProfileAssignmentName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomanageClientConf")
    public static interface ConfigurationProfileHcrpAssignmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="machineName") String var4, @PathParam(value="configurationProfileAssignmentName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConfigurationProfileAssignmentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileAssignmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="machineName") String var4, @PathParam(value="configurationProfileAssignmentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="machineName") String var4, @PathParam(value="configurationProfileAssignmentName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

