/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileInner;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.ConfigurationProfile;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileProperties;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileUpdate;
import java.util.Collections;
import java.util.Map;

public final class ConfigurationProfileImpl
implements ConfigurationProfile,
ConfigurationProfile.Definition,
ConfigurationProfile.Update {
    private ConfigurationProfileInner innerObject;
    private final AutomanageManager serviceManager;
    private String configurationProfileName;
    private String resourceGroupName;
    private ConfigurationProfileUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ConfigurationProfileProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConfigurationProfileInner innerModel() {
        return this.innerObject;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationProfileImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ConfigurationProfile create() {
        this.innerObject = (ConfigurationProfileInner)((Object)this.serviceManager.serviceClient().getConfigurationProfiles().createOrUpdateWithResponse(this.configurationProfileName, this.resourceGroupName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationProfile create(Context context) {
        this.innerObject = (ConfigurationProfileInner)((Object)this.serviceManager.serviceClient().getConfigurationProfiles().createOrUpdateWithResponse(this.configurationProfileName, this.resourceGroupName, this.innerModel(), context).getValue());
        return this;
    }

    ConfigurationProfileImpl(String name, AutomanageManager serviceManager) {
        this.innerObject = new ConfigurationProfileInner();
        this.serviceManager = serviceManager;
        this.configurationProfileName = name;
    }

    @Override
    public ConfigurationProfileImpl update() {
        this.updateParameters = new ConfigurationProfileUpdate();
        return this;
    }

    @Override
    public ConfigurationProfile apply() {
        this.innerObject = (ConfigurationProfileInner)((Object)this.serviceManager.serviceClient().getConfigurationProfiles().updateWithResponse(this.configurationProfileName, this.resourceGroupName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationProfile apply(Context context) {
        this.innerObject = (ConfigurationProfileInner)((Object)this.serviceManager.serviceClient().getConfigurationProfiles().updateWithResponse(this.configurationProfileName, this.resourceGroupName, this.updateParameters, context).getValue());
        return this;
    }

    ConfigurationProfileImpl(ConfigurationProfileInner innerObject, AutomanageManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.configurationProfileName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurationProfiles");
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
    }

    @Override
    public ConfigurationProfile refresh() {
        this.innerObject = (ConfigurationProfileInner)((Object)this.serviceManager.serviceClient().getConfigurationProfiles().getByResourceGroupWithResponse(this.resourceGroupName, this.configurationProfileName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationProfile refresh(Context context) {
        this.innerObject = (ConfigurationProfileInner)((Object)this.serviceManager.serviceClient().getConfigurationProfiles().getByResourceGroupWithResponse(this.resourceGroupName, this.configurationProfileName, context).getValue());
        return this;
    }

    @Override
    public ConfigurationProfileImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ConfigurationProfileImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ConfigurationProfileImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags((Map)tags);
        return this;
    }

    @Override
    public ConfigurationProfileImpl withProperties(ConfigurationProfileProperties properties) {
        if (this.isInCreateMode()) {
            this.innerModel().withProperties(properties);
            return this;
        }
        this.updateParameters.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

