/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfilesClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileInner;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileImpl;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.ConfigurationProfile;
import com.azure.resourcemanager.automanage.models.ConfigurationProfiles;

public final class ConfigurationProfilesImpl
implements ConfigurationProfiles {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationProfilesImpl.class);
    private final ConfigurationProfilesClient innerClient;
    private final AutomanageManager serviceManager;

    public ConfigurationProfilesImpl(ConfigurationProfilesClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConfigurationProfile> getByResourceGroupWithResponse(String resourceGroupName, String configurationProfileName, Context context) {
        Response<ConfigurationProfileInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, configurationProfileName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationProfile getByResourceGroup(String resourceGroupName, String configurationProfileName) {
        ConfigurationProfileInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, configurationProfileName);
        if (inner != null) {
            return new ConfigurationProfileImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String configurationProfileName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, configurationProfileName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String configurationProfileName) {
        this.serviceClient().delete(resourceGroupName, configurationProfileName);
    }

    @Override
    public PagedIterable<ConfigurationProfile> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ConfigurationProfileInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfile> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ConfigurationProfileInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfile> list() {
        PagedIterable<ConfigurationProfileInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfile> list(Context context) {
        PagedIterable<ConfigurationProfileInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public ConfigurationProfile getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfiles");
        if (configurationProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfiles'.", id)));
        }
        return (ConfigurationProfile)this.getByResourceGroupWithResponse(resourceGroupName, configurationProfileName, Context.NONE).getValue();
    }

    @Override
    public Response<ConfigurationProfile> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfiles");
        if (configurationProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfiles'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, configurationProfileName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfiles");
        if (configurationProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfiles'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, configurationProfileName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configurationProfileName = ResourceManagerUtils.getValueFromIdByName(id, "configurationProfiles");
        if (configurationProfileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationProfiles'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, configurationProfileName, context);
    }

    private ConfigurationProfilesClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationProfileImpl define(String name) {
        return new ConfigurationProfileImpl(name, this.manager());
    }
}

