/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfilesVersionsClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileInner;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientImpl;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileList;
import reactor.core.publisher.Mono;

public final class ConfigurationProfilesVersionsClientImpl
implements ConfigurationProfilesVersionsClient {
    private final ConfigurationProfilesVersionsService service;
    private final AutomanageClientImpl client;

    ConfigurationProfilesVersionsClientImpl(AutomanageClientImpl client) {
        this.service = (ConfigurationProfilesVersionsService)RestProxy.create(ConfigurationProfilesVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileInner>> createOrUpdateWithResponseAsync(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), configurationProfileName, versionName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileInner>> createOrUpdateWithResponseAsync(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), configurationProfileName, versionName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationProfileInner> createOrUpdateAsync(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters) {
        return this.createOrUpdateWithResponseAsync(configurationProfileName, versionName, resourceGroupName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConfigurationProfileInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationProfileInner> createOrUpdateWithResponse(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(configurationProfileName, versionName, resourceGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationProfileInner createOrUpdate(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters) {
        return (ConfigurationProfileInner)((Object)this.createOrUpdateWithResponse(configurationProfileName, versionName, resourceGroupName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileInner>> getWithResponseAsync(String configurationProfileName, String versionName, String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), configurationProfileName, versionName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationProfileInner>> getWithResponseAsync(String configurationProfileName, String versionName, String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), configurationProfileName, versionName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationProfileInner> getAsync(String configurationProfileName, String versionName, String resourceGroupName) {
        return this.getWithResponseAsync(configurationProfileName, versionName, resourceGroupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConfigurationProfileInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationProfileInner> getWithResponse(String configurationProfileName, String versionName, String resourceGroupName, Context context) {
        return (Response)this.getWithResponseAsync(configurationProfileName, versionName, resourceGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationProfileInner get(String configurationProfileName, String versionName, String resourceGroupName) {
        return (ConfigurationProfileInner)((Object)this.getWithResponse(configurationProfileName, versionName, resourceGroupName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String configurationProfileName, String versionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, configurationProfileName, versionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String configurationProfileName, String versionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, configurationProfileName, versionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String configurationProfileName, String versionName) {
        return this.deleteWithResponseAsync(resourceGroupName, configurationProfileName, versionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String configurationProfileName, String versionName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, configurationProfileName, versionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String configurationProfileName, String versionName) {
        this.deleteWithResponse(resourceGroupName, configurationProfileName, versionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileInner>> listChildResourcesSinglePageAsync(String configurationProfileName, String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChildResources(this.client.getEndpoint(), configurationProfileName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationProfileInner>> listChildResourcesSinglePageAsync(String configurationProfileName, String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (configurationProfileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listChildResources(this.client.getEndpoint(), configurationProfileName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationProfileList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileInner> listChildResourcesAsync(String configurationProfileName, String resourceGroupName) {
        return new PagedFlux(() -> this.listChildResourcesSinglePageAsync(configurationProfileName, resourceGroupName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationProfileInner> listChildResourcesAsync(String configurationProfileName, String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listChildResourcesSinglePageAsync(configurationProfileName, resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileInner> listChildResources(String configurationProfileName, String resourceGroupName) {
        return new PagedIterable(this.listChildResourcesAsync(configurationProfileName, resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationProfileInner> listChildResources(String configurationProfileName, String resourceGroupName, Context context) {
        return new PagedIterable(this.listChildResourcesAsync(configurationProfileName, resourceGroupName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomanageClientConf")
    public static interface ConfigurationProfilesVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}/versions/{versionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="configurationProfileName") String var2, @PathParam(value="versionName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceGroupName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConfigurationProfileInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}/versions/{versionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileInner>> get(@HostParam(value="$host") String var1, @PathParam(value="configurationProfileName") String var2, @PathParam(value="versionName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceGroupName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}/versions/{versionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="configurationProfileName") String var3, @PathParam(value="versionName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationProfileList>> listChildResources(@HostParam(value="$host") String var1, @PathParam(value="configurationProfileName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

