/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.ConfigurationProfilesVersionsClient;
import com.azure.resourcemanager.automanage.fluent.models.ConfigurationProfileInner;
import com.azure.resourcemanager.automanage.implementation.ConfigurationProfileImpl;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.ConfigurationProfile;
import com.azure.resourcemanager.automanage.models.ConfigurationProfilesVersions;

public final class ConfigurationProfilesVersionsImpl
implements ConfigurationProfilesVersions {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationProfilesVersionsImpl.class);
    private final ConfigurationProfilesVersionsClient innerClient;
    private final AutomanageManager serviceManager;

    public ConfigurationProfilesVersionsImpl(ConfigurationProfilesVersionsClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConfigurationProfile> createOrUpdateWithResponse(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters, Context context) {
        Response<ConfigurationProfileInner> inner = this.serviceClient().createOrUpdateWithResponse(configurationProfileName, versionName, resourceGroupName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationProfile createOrUpdate(String configurationProfileName, String versionName, String resourceGroupName, ConfigurationProfileInner parameters) {
        ConfigurationProfileInner inner = this.serviceClient().createOrUpdate(configurationProfileName, versionName, resourceGroupName, parameters);
        if (inner != null) {
            return new ConfigurationProfileImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ConfigurationProfile> getWithResponse(String configurationProfileName, String versionName, String resourceGroupName, Context context) {
        Response<ConfigurationProfileInner> inner = this.serviceClient().getWithResponse(configurationProfileName, versionName, resourceGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationProfile get(String configurationProfileName, String versionName, String resourceGroupName) {
        ConfigurationProfileInner inner = this.serviceClient().get(configurationProfileName, versionName, resourceGroupName);
        if (inner != null) {
            return new ConfigurationProfileImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String configurationProfileName, String versionName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, configurationProfileName, versionName, context);
    }

    @Override
    public void delete(String resourceGroupName, String configurationProfileName, String versionName) {
        this.serviceClient().delete(resourceGroupName, configurationProfileName, versionName);
    }

    @Override
    public PagedIterable<ConfigurationProfile> listChildResources(String configurationProfileName, String resourceGroupName) {
        PagedIterable<ConfigurationProfileInner> inner = this.serviceClient().listChildResources(configurationProfileName, resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationProfile> listChildResources(String configurationProfileName, String resourceGroupName, Context context) {
        PagedIterable<ConfigurationProfileInner> inner = this.serviceClient().listChildResources(configurationProfileName, resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationProfileImpl((ConfigurationProfileInner)((Object)inner1), this.manager()));
    }

    private ConfigurationProfilesVersionsClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }
}

