/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.HciReportsClient;
import com.azure.resourcemanager.automanage.fluent.models.ReportInner;
import com.azure.resourcemanager.automanage.implementation.ReportImpl;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.models.HciReports;
import com.azure.resourcemanager.automanage.models.Report;

public final class HciReportsImpl
implements HciReports {
    private static final ClientLogger LOGGER = new ClientLogger(HciReportsImpl.class);
    private final HciReportsClient innerClient;
    private final AutomanageManager serviceManager;

    public HciReportsImpl(HciReportsClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Report> getWithResponse(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, String reportName, Context context) {
        Response<ReportInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, configurationProfileAssignmentName, reportName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReportImpl((ReportInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Report get(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, String reportName) {
        ReportInner inner = this.serviceClient().get(resourceGroupName, clusterName, configurationProfileAssignmentName, reportName);
        if (inner != null) {
            return new ReportImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Report> listByConfigurationProfileAssignments(String resourceGroupName, String clusterName, String configurationProfileAssignmentName) {
        PagedIterable<ReportInner> inner = this.serviceClient().listByConfigurationProfileAssignments(resourceGroupName, clusterName, configurationProfileAssignmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportImpl((ReportInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Report> listByConfigurationProfileAssignments(String resourceGroupName, String clusterName, String configurationProfileAssignmentName, Context context) {
        PagedIterable<ReportInner> inner = this.serviceClient().listByConfigurationProfileAssignments(resourceGroupName, clusterName, configurationProfileAssignmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReportImpl((ReportInner)((Object)inner1), this.manager()));
    }

    private HciReportsClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }
}

