/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automanage.fluent.ReportsClient;
import com.azure.resourcemanager.automanage.fluent.models.ReportInner;
import com.azure.resourcemanager.automanage.implementation.AutomanageClientImpl;
import com.azure.resourcemanager.automanage.models.ReportList;
import reactor.core.publisher.Mono;

public final class ReportsClientImpl
implements ReportsClient {
    private final ReportsService service;
    private final AutomanageClientImpl client;

    ReportsClientImpl(AutomanageClientImpl client) {
        this.service = (ReportsService)RestProxy.create(ReportsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ReportInner>> getWithResponseAsync(String resourceGroupName, String configurationProfileAssignmentName, String reportName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (reportName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reportName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, configurationProfileAssignmentName, reportName, this.client.getSubscriptionId(), vmName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ReportInner>> getWithResponseAsync(String resourceGroupName, String configurationProfileAssignmentName, String reportName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (reportName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter reportName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, configurationProfileAssignmentName, reportName, this.client.getSubscriptionId(), vmName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ReportInner> getAsync(String resourceGroupName, String configurationProfileAssignmentName, String reportName, String vmName) {
        return this.getWithResponseAsync(resourceGroupName, configurationProfileAssignmentName, reportName, vmName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ReportInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReportInner> getWithResponse(String resourceGroupName, String configurationProfileAssignmentName, String reportName, String vmName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, configurationProfileAssignmentName, reportName, vmName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReportInner get(String resourceGroupName, String configurationProfileAssignmentName, String reportName, String vmName) {
        return (ReportInner)((Object)this.getWithResponse(resourceGroupName, configurationProfileAssignmentName, reportName, vmName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReportInner>> listByConfigurationProfileAssignmentsSinglePageAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByConfigurationProfileAssignments(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configurationProfileAssignmentName, vmName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReportList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ReportInner>> listByConfigurationProfileAssignmentsSinglePageAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configurationProfileAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationProfileAssignmentName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByConfigurationProfileAssignments(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configurationProfileAssignmentName, vmName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ReportList)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ReportInner> listByConfigurationProfileAssignmentsAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        return new PagedFlux(() -> this.listByConfigurationProfileAssignmentsSinglePageAsync(resourceGroupName, configurationProfileAssignmentName, vmName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ReportInner> listByConfigurationProfileAssignmentsAsync(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        return new PagedFlux(() -> this.listByConfigurationProfileAssignmentsSinglePageAsync(resourceGroupName, configurationProfileAssignmentName, vmName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ReportInner> listByConfigurationProfileAssignments(String resourceGroupName, String configurationProfileAssignmentName, String vmName) {
        return new PagedIterable(this.listByConfigurationProfileAssignmentsAsync(resourceGroupName, configurationProfileAssignmentName, vmName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ReportInner> listByConfigurationProfileAssignments(String resourceGroupName, String configurationProfileAssignmentName, String vmName, Context context) {
        return new PagedIterable(this.listByConfigurationProfileAssignmentsAsync(resourceGroupName, configurationProfileAssignmentName, vmName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomanageClientRepo")
    public static interface ReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports/{reportName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReportInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="configurationProfileAssignmentName") String var3, @PathParam(value="reportName") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="vmName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ReportList>> listByConfigurationProfileAssignments(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configurationProfileAssignmentName") String var4, @PathParam(value="vmName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

