/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automanage.AutomanageManager;
import com.azure.resourcemanager.automanage.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.automanage.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.automanage.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automanage.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.automanage.models.ServicePrincipal;
import com.azure.resourcemanager.automanage.models.ServicePrincipals;

public final class ServicePrincipalsImpl
implements ServicePrincipals {
    private static final ClientLogger LOGGER = new ClientLogger(ServicePrincipalsImpl.class);
    private final ServicePrincipalsClient innerClient;
    private final AutomanageManager serviceManager;

    public ServicePrincipalsImpl(ServicePrincipalsClient innerClient, AutomanageManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ServicePrincipal> list() {
        PagedIterable<ServicePrincipalInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServicePrincipalImpl((ServicePrincipalInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServicePrincipal> list(Context context) {
        PagedIterable<ServicePrincipalInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServicePrincipalImpl((ServicePrincipalInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ServicePrincipal> getWithResponse(Context context) {
        Response<ServicePrincipalInner> inner = this.serviceClient().getWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServicePrincipalImpl((ServicePrincipalInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServicePrincipal get() {
        ServicePrincipalInner inner = this.serviceClient().get();
        if (inner != null) {
            return new ServicePrincipalImpl(inner, this.manager());
        }
        return null;
    }

    private ServicePrincipalsClient serviceClient() {
        return this.innerClient;
    }

    private AutomanageManager manager() {
        return this.serviceManager;
    }
}

