/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automanage.models.ReportResource;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class AssignmentReportProperties
implements JsonSerializable<AssignmentReportProperties> {
    private String startTime;
    private String endTime;
    private String lastModifiedTime;
    private Duration duration;
    private String type;
    private String status;
    private String configurationProfile;
    private List<ReportResource> resources;
    private ManagementError error;
    private String reportFormatVersion;

    public String startTime() {
        return this.startTime;
    }

    public AssignmentReportProperties withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public AssignmentReportProperties withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Duration duration() {
        return this.duration;
    }

    public String type() {
        return this.type;
    }

    public String status() {
        return this.status;
    }

    public String configurationProfile() {
        return this.configurationProfile;
    }

    public List<ReportResource> resources() {
        return this.resources;
    }

    public ManagementError error() {
        return this.error;
    }

    public String reportFormatVersion() {
        return this.reportFormatVersion;
    }

    public void validate() {
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        return jsonWriter.writeEndObject();
    }

    public static AssignmentReportProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AssignmentReportProperties)jsonReader.readObject(reader -> {
            AssignmentReportProperties deserializedAssignmentReportProperties = new AssignmentReportProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedAssignmentReportProperties.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAssignmentReportProperties.endTime = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedAssignmentReportProperties.lastModifiedTime = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedAssignmentReportProperties.duration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAssignmentReportProperties.type = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAssignmentReportProperties.status = reader.getString();
                    continue;
                }
                if ("configurationProfile".equals(fieldName)) {
                    deserializedAssignmentReportProperties.configurationProfile = reader.getString();
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedAssignmentReportProperties.resources = resources = reader.readArray(reader1 -> ReportResource.fromJson(reader1));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAssignmentReportProperties.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("reportFormatVersion".equals(fieldName)) {
                    deserializedAssignmentReportProperties.reportFormatVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAssignmentReportProperties;
        });
    }
}

