/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automanage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automanage.models.ConfigurationProfileProperties;
import com.azure.resourcemanager.automanage.models.UpdateResource;
import java.io.IOException;
import java.util.Map;

public final class ConfigurationProfileUpdate
extends UpdateResource {
    private ConfigurationProfileProperties properties;

    public ConfigurationProfileProperties properties() {
        return this.properties;
    }

    public ConfigurationProfileUpdate withProperties(ConfigurationProfileProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public ConfigurationProfileUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationProfileUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationProfileUpdate)jsonReader.readObject(reader -> {
            ConfigurationProfileUpdate deserializedConfigurationProfileUpdate = new ConfigurationProfileUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConfigurationProfileUpdate.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigurationProfileUpdate.properties = ConfigurationProfileProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationProfileUpdate;
        });
    }
}

