/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.fluent.AutomationClient;
import com.azure.resourcemanager.automation.implementation.ActivitiesImpl;
import com.azure.resourcemanager.automation.implementation.AgentRegistrationInformationsImpl;
import com.azure.resourcemanager.automation.implementation.AutomationAccountsImpl;
import com.azure.resourcemanager.automation.implementation.AutomationClientBuilder;
import com.azure.resourcemanager.automation.implementation.CertificatesImpl;
import com.azure.resourcemanager.automation.implementation.ConnectionTypesImpl;
import com.azure.resourcemanager.automation.implementation.ConnectionsImpl;
import com.azure.resourcemanager.automation.implementation.CredentialsImpl;
import com.azure.resourcemanager.automation.implementation.DeletedAutomationAccountsImpl;
import com.azure.resourcemanager.automation.implementation.DscCompilationJobStreamsImpl;
import com.azure.resourcemanager.automation.implementation.DscCompilationJobsImpl;
import com.azure.resourcemanager.automation.implementation.DscConfigurationsImpl;
import com.azure.resourcemanager.automation.implementation.DscNodeConfigurationsImpl;
import com.azure.resourcemanager.automation.implementation.DscNodesImpl;
import com.azure.resourcemanager.automation.implementation.FieldsImpl;
import com.azure.resourcemanager.automation.implementation.HybridRunbookWorkerGroupsImpl;
import com.azure.resourcemanager.automation.implementation.HybridRunbookWorkersImpl;
import com.azure.resourcemanager.automation.implementation.JobSchedulesImpl;
import com.azure.resourcemanager.automation.implementation.JobStreamsImpl;
import com.azure.resourcemanager.automation.implementation.JobsImpl;
import com.azure.resourcemanager.automation.implementation.KeysImpl;
import com.azure.resourcemanager.automation.implementation.LinkedWorkspacesImpl;
import com.azure.resourcemanager.automation.implementation.ModulesImpl;
import com.azure.resourcemanager.automation.implementation.NodeCountInformationsImpl;
import com.azure.resourcemanager.automation.implementation.NodeReportsImpl;
import com.azure.resourcemanager.automation.implementation.ObjectDataTypesImpl;
import com.azure.resourcemanager.automation.implementation.OperationsImpl;
import com.azure.resourcemanager.automation.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.automation.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.automation.implementation.Python2PackagesImpl;
import com.azure.resourcemanager.automation.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.automation.implementation.RunbookDraftsImpl;
import com.azure.resourcemanager.automation.implementation.RunbooksImpl;
import com.azure.resourcemanager.automation.implementation.SchedulesImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationMachineRunsImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationRunsImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationsImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobStreamsImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobsImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlsImpl;
import com.azure.resourcemanager.automation.implementation.StatisticsOperationsImpl;
import com.azure.resourcemanager.automation.implementation.TestJobStreamsImpl;
import com.azure.resourcemanager.automation.implementation.TestJobsImpl;
import com.azure.resourcemanager.automation.implementation.UsagesImpl;
import com.azure.resourcemanager.automation.implementation.VariablesImpl;
import com.azure.resourcemanager.automation.implementation.WatchersImpl;
import com.azure.resourcemanager.automation.implementation.WebhooksImpl;
import com.azure.resourcemanager.automation.models.Activities;
import com.azure.resourcemanager.automation.models.AgentRegistrationInformations;
import com.azure.resourcemanager.automation.models.AutomationAccounts;
import com.azure.resourcemanager.automation.models.Certificates;
import com.azure.resourcemanager.automation.models.ConnectionTypes;
import com.azure.resourcemanager.automation.models.Connections;
import com.azure.resourcemanager.automation.models.Credentials;
import com.azure.resourcemanager.automation.models.DeletedAutomationAccounts;
import com.azure.resourcemanager.automation.models.DscCompilationJobStreams;
import com.azure.resourcemanager.automation.models.DscCompilationJobs;
import com.azure.resourcemanager.automation.models.DscConfigurations;
import com.azure.resourcemanager.automation.models.DscNodeConfigurations;
import com.azure.resourcemanager.automation.models.DscNodes;
import com.azure.resourcemanager.automation.models.Fields;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkerGroups;
import com.azure.resourcemanager.automation.models.HybridRunbookWorkers;
import com.azure.resourcemanager.automation.models.JobSchedules;
import com.azure.resourcemanager.automation.models.JobStreams;
import com.azure.resourcemanager.automation.models.Jobs;
import com.azure.resourcemanager.automation.models.Keys;
import com.azure.resourcemanager.automation.models.LinkedWorkspaces;
import com.azure.resourcemanager.automation.models.Modules;
import com.azure.resourcemanager.automation.models.NodeCountInformations;
import com.azure.resourcemanager.automation.models.NodeReports;
import com.azure.resourcemanager.automation.models.ObjectDataTypes;
import com.azure.resourcemanager.automation.models.Operations;
import com.azure.resourcemanager.automation.models.PrivateEndpointConnections;
import com.azure.resourcemanager.automation.models.PrivateLinkResources;
import com.azure.resourcemanager.automation.models.Python2Packages;
import com.azure.resourcemanager.automation.models.ResourceProviders;
import com.azure.resourcemanager.automation.models.RunbookDrafts;
import com.azure.resourcemanager.automation.models.Runbooks;
import com.azure.resourcemanager.automation.models.Schedules;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationMachineRuns;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationRuns;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurations;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobStreams;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobs;
import com.azure.resourcemanager.automation.models.SourceControls;
import com.azure.resourcemanager.automation.models.StatisticsOperations;
import com.azure.resourcemanager.automation.models.TestJobStreams;
import com.azure.resourcemanager.automation.models.TestJobs;
import com.azure.resourcemanager.automation.models.Usages;
import com.azure.resourcemanager.automation.models.Variables;
import com.azure.resourcemanager.automation.models.Watchers;
import com.azure.resourcemanager.automation.models.Webhooks;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class AutomationManager {
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private Python2Packages python2Packages;
    private AgentRegistrationInformations agentRegistrationInformations;
    private DscNodes dscNodes;
    private NodeReports nodeReports;
    private DscNodeConfigurations dscNodeConfigurations;
    private DscCompilationJobs dscCompilationJobs;
    private DscCompilationJobStreams dscCompilationJobStreams;
    private NodeCountInformations nodeCountInformations;
    private SourceControls sourceControls;
    private SourceControlSyncJobs sourceControlSyncJobs;
    private SourceControlSyncJobStreams sourceControlSyncJobStreams;
    private AutomationAccounts automationAccounts;
    private StatisticsOperations statisticsOperations;
    private Usages usages;
    private Keys keys;
    private Certificates certificates;
    private Connections connections;
    private ConnectionTypes connectionTypes;
    private Credentials credentials;
    private JobSchedules jobSchedules;
    private LinkedWorkspaces linkedWorkspaces;
    private Activities activities;
    private Modules modules;
    private ObjectDataTypes objectDataTypes;
    private Fields fields;
    private Schedules schedules;
    private Variables variables;
    private Watchers watchers;
    private DscConfigurations dscConfigurations;
    private Jobs jobs;
    private JobStreams jobStreams;
    private Operations operations;
    private ResourceProviders resourceProviders;
    private SoftwareUpdateConfigurations softwareUpdateConfigurations;
    private SoftwareUpdateConfigurationRuns softwareUpdateConfigurationRuns;
    private SoftwareUpdateConfigurationMachineRuns softwareUpdateConfigurationMachineRuns;
    private RunbookDrafts runbookDrafts;
    private Runbooks runbooks;
    private TestJobStreams testJobStreams;
    private TestJobs testJobs;
    private Webhooks webhooks;
    private HybridRunbookWorkers hybridRunbookWorkers;
    private DeletedAutomationAccounts deletedAutomationAccounts;
    private HybridRunbookWorkerGroups hybridRunbookWorkerGroups;
    private final AutomationClient clientObject;

    private AutomationManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new AutomationClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static AutomationManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return AutomationManager.configure().authenticate(credential, profile);
    }

    public static AutomationManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new AutomationManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public Python2Packages python2Packages() {
        if (this.python2Packages == null) {
            this.python2Packages = new Python2PackagesImpl(this.clientObject.getPython2Packages(), this);
        }
        return this.python2Packages;
    }

    public AgentRegistrationInformations agentRegistrationInformations() {
        if (this.agentRegistrationInformations == null) {
            this.agentRegistrationInformations = new AgentRegistrationInformationsImpl(this.clientObject.getAgentRegistrationInformations(), this);
        }
        return this.agentRegistrationInformations;
    }

    public DscNodes dscNodes() {
        if (this.dscNodes == null) {
            this.dscNodes = new DscNodesImpl(this.clientObject.getDscNodes(), this);
        }
        return this.dscNodes;
    }

    public NodeReports nodeReports() {
        if (this.nodeReports == null) {
            this.nodeReports = new NodeReportsImpl(this.clientObject.getNodeReports(), this);
        }
        return this.nodeReports;
    }

    public DscNodeConfigurations dscNodeConfigurations() {
        if (this.dscNodeConfigurations == null) {
            this.dscNodeConfigurations = new DscNodeConfigurationsImpl(this.clientObject.getDscNodeConfigurations(), this);
        }
        return this.dscNodeConfigurations;
    }

    public DscCompilationJobs dscCompilationJobs() {
        if (this.dscCompilationJobs == null) {
            this.dscCompilationJobs = new DscCompilationJobsImpl(this.clientObject.getDscCompilationJobs(), this);
        }
        return this.dscCompilationJobs;
    }

    public DscCompilationJobStreams dscCompilationJobStreams() {
        if (this.dscCompilationJobStreams == null) {
            this.dscCompilationJobStreams = new DscCompilationJobStreamsImpl(this.clientObject.getDscCompilationJobStreams(), this);
        }
        return this.dscCompilationJobStreams;
    }

    public NodeCountInformations nodeCountInformations() {
        if (this.nodeCountInformations == null) {
            this.nodeCountInformations = new NodeCountInformationsImpl(this.clientObject.getNodeCountInformations(), this);
        }
        return this.nodeCountInformations;
    }

    public SourceControls sourceControls() {
        if (this.sourceControls == null) {
            this.sourceControls = new SourceControlsImpl(this.clientObject.getSourceControls(), this);
        }
        return this.sourceControls;
    }

    public SourceControlSyncJobs sourceControlSyncJobs() {
        if (this.sourceControlSyncJobs == null) {
            this.sourceControlSyncJobs = new SourceControlSyncJobsImpl(this.clientObject.getSourceControlSyncJobs(), this);
        }
        return this.sourceControlSyncJobs;
    }

    public SourceControlSyncJobStreams sourceControlSyncJobStreams() {
        if (this.sourceControlSyncJobStreams == null) {
            this.sourceControlSyncJobStreams = new SourceControlSyncJobStreamsImpl(this.clientObject.getSourceControlSyncJobStreams(), this);
        }
        return this.sourceControlSyncJobStreams;
    }

    public AutomationAccounts automationAccounts() {
        if (this.automationAccounts == null) {
            this.automationAccounts = new AutomationAccountsImpl(this.clientObject.getAutomationAccounts(), this);
        }
        return this.automationAccounts;
    }

    public StatisticsOperations statisticsOperations() {
        if (this.statisticsOperations == null) {
            this.statisticsOperations = new StatisticsOperationsImpl(this.clientObject.getStatisticsOperations(), this);
        }
        return this.statisticsOperations;
    }

    public Usages usages() {
        if (this.usages == null) {
            this.usages = new UsagesImpl(this.clientObject.getUsages(), this);
        }
        return this.usages;
    }

    public Keys keys() {
        if (this.keys == null) {
            this.keys = new KeysImpl(this.clientObject.getKeys(), this);
        }
        return this.keys;
    }

    public Certificates certificates() {
        if (this.certificates == null) {
            this.certificates = new CertificatesImpl(this.clientObject.getCertificates(), this);
        }
        return this.certificates;
    }

    public Connections connections() {
        if (this.connections == null) {
            this.connections = new ConnectionsImpl(this.clientObject.getConnections(), this);
        }
        return this.connections;
    }

    public ConnectionTypes connectionTypes() {
        if (this.connectionTypes == null) {
            this.connectionTypes = new ConnectionTypesImpl(this.clientObject.getConnectionTypes(), this);
        }
        return this.connectionTypes;
    }

    public Credentials credentials() {
        if (this.credentials == null) {
            this.credentials = new CredentialsImpl(this.clientObject.getCredentials(), this);
        }
        return this.credentials;
    }

    public JobSchedules jobSchedules() {
        if (this.jobSchedules == null) {
            this.jobSchedules = new JobSchedulesImpl(this.clientObject.getJobSchedules(), this);
        }
        return this.jobSchedules;
    }

    public LinkedWorkspaces linkedWorkspaces() {
        if (this.linkedWorkspaces == null) {
            this.linkedWorkspaces = new LinkedWorkspacesImpl(this.clientObject.getLinkedWorkspaces(), this);
        }
        return this.linkedWorkspaces;
    }

    public Activities activities() {
        if (this.activities == null) {
            this.activities = new ActivitiesImpl(this.clientObject.getActivities(), this);
        }
        return this.activities;
    }

    public Modules modules() {
        if (this.modules == null) {
            this.modules = new ModulesImpl(this.clientObject.getModules(), this);
        }
        return this.modules;
    }

    public ObjectDataTypes objectDataTypes() {
        if (this.objectDataTypes == null) {
            this.objectDataTypes = new ObjectDataTypesImpl(this.clientObject.getObjectDataTypes(), this);
        }
        return this.objectDataTypes;
    }

    public Fields fields() {
        if (this.fields == null) {
            this.fields = new FieldsImpl(this.clientObject.getFields(), this);
        }
        return this.fields;
    }

    public Schedules schedules() {
        if (this.schedules == null) {
            this.schedules = new SchedulesImpl(this.clientObject.getSchedules(), this);
        }
        return this.schedules;
    }

    public Variables variables() {
        if (this.variables == null) {
            this.variables = new VariablesImpl(this.clientObject.getVariables(), this);
        }
        return this.variables;
    }

    public Watchers watchers() {
        if (this.watchers == null) {
            this.watchers = new WatchersImpl(this.clientObject.getWatchers(), this);
        }
        return this.watchers;
    }

    public DscConfigurations dscConfigurations() {
        if (this.dscConfigurations == null) {
            this.dscConfigurations = new DscConfigurationsImpl(this.clientObject.getDscConfigurations(), this);
        }
        return this.dscConfigurations;
    }

    public Jobs jobs() {
        if (this.jobs == null) {
            this.jobs = new JobsImpl(this.clientObject.getJobs(), this);
        }
        return this.jobs;
    }

    public JobStreams jobStreams() {
        if (this.jobStreams == null) {
            this.jobStreams = new JobStreamsImpl(this.clientObject.getJobStreams(), this);
        }
        return this.jobStreams;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public SoftwareUpdateConfigurations softwareUpdateConfigurations() {
        if (this.softwareUpdateConfigurations == null) {
            this.softwareUpdateConfigurations = new SoftwareUpdateConfigurationsImpl(this.clientObject.getSoftwareUpdateConfigurations(), this);
        }
        return this.softwareUpdateConfigurations;
    }

    public SoftwareUpdateConfigurationRuns softwareUpdateConfigurationRuns() {
        if (this.softwareUpdateConfigurationRuns == null) {
            this.softwareUpdateConfigurationRuns = new SoftwareUpdateConfigurationRunsImpl(this.clientObject.getSoftwareUpdateConfigurationRuns(), this);
        }
        return this.softwareUpdateConfigurationRuns;
    }

    public SoftwareUpdateConfigurationMachineRuns softwareUpdateConfigurationMachineRuns() {
        if (this.softwareUpdateConfigurationMachineRuns == null) {
            this.softwareUpdateConfigurationMachineRuns = new SoftwareUpdateConfigurationMachineRunsImpl(this.clientObject.getSoftwareUpdateConfigurationMachineRuns(), this);
        }
        return this.softwareUpdateConfigurationMachineRuns;
    }

    public RunbookDrafts runbookDrafts() {
        if (this.runbookDrafts == null) {
            this.runbookDrafts = new RunbookDraftsImpl(this.clientObject.getRunbookDrafts(), this);
        }
        return this.runbookDrafts;
    }

    public Runbooks runbooks() {
        if (this.runbooks == null) {
            this.runbooks = new RunbooksImpl(this.clientObject.getRunbooks(), this);
        }
        return this.runbooks;
    }

    public TestJobStreams testJobStreams() {
        if (this.testJobStreams == null) {
            this.testJobStreams = new TestJobStreamsImpl(this.clientObject.getTestJobStreams(), this);
        }
        return this.testJobStreams;
    }

    public TestJobs testJobs() {
        if (this.testJobs == null) {
            this.testJobs = new TestJobsImpl(this.clientObject.getTestJobs(), this);
        }
        return this.testJobs;
    }

    public Webhooks webhooks() {
        if (this.webhooks == null) {
            this.webhooks = new WebhooksImpl(this.clientObject.getWebhooks(), this);
        }
        return this.webhooks;
    }

    public HybridRunbookWorkers hybridRunbookWorkers() {
        if (this.hybridRunbookWorkers == null) {
            this.hybridRunbookWorkers = new HybridRunbookWorkersImpl(this.clientObject.getHybridRunbookWorkers(), this);
        }
        return this.hybridRunbookWorkers;
    }

    public DeletedAutomationAccounts deletedAutomationAccounts() {
        if (this.deletedAutomationAccounts == null) {
            this.deletedAutomationAccounts = new DeletedAutomationAccountsImpl(this.clientObject.getDeletedAutomationAccounts(), this);
        }
        return this.deletedAutomationAccounts;
    }

    public HybridRunbookWorkerGroups hybridRunbookWorkerGroups() {
        if (this.hybridRunbookWorkerGroups == null) {
            this.hybridRunbookWorkerGroups = new HybridRunbookWorkerGroupsImpl(this.clientObject.getHybridRunbookWorkerGroups(), this);
        }
        return this.hybridRunbookWorkerGroups;
    }

    public AutomationClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public AutomationManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.automation").append("/").append("1.0.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new AutomationManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

