/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ActivityProperties;
import com.azure.resourcemanager.automation.models.ActivityOutputType;
import com.azure.resourcemanager.automation.models.ActivityParameterSet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ActivityInner
implements JsonSerializable<ActivityInner> {
    private String id;
    private String name;
    private ActivityProperties innerProperties;

    public String id() {
        return this.id;
    }

    public ActivityInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    private ActivityProperties innerProperties() {
        return this.innerProperties;
    }

    public String definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    public ActivityInner withDefinition(String definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActivityProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    public List<ActivityParameterSet> parameterSets() {
        return this.innerProperties() == null ? null : this.innerProperties().parameterSets();
    }

    public ActivityInner withParameterSets(List<ActivityParameterSet> parameterSets) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActivityProperties();
        }
        this.innerProperties().withParameterSets(parameterSets);
        return this;
    }

    public List<ActivityOutputType> outputTypes() {
        return this.innerProperties() == null ? null : this.innerProperties().outputTypes();
    }

    public ActivityInner withOutputTypes(List<ActivityOutputType> outputTypes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActivityProperties();
        }
        this.innerProperties().withOutputTypes(outputTypes);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public ActivityInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActivityProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public ActivityInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActivityProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ActivityInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActivityProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ActivityInner fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityInner)jsonReader.readObject(reader -> {
            ActivityInner deserializedActivityInner = new ActivityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedActivityInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedActivityInner.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedActivityInner.innerProperties = ActivityProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityInner;
        });
    }
}

