/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ActivityOutputType;
import com.azure.resourcemanager.automation.models.ActivityParameterSet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ActivityProperties
implements JsonSerializable<ActivityProperties> {
    private String definition;
    private List<ActivityParameterSet> parameterSets;
    private List<ActivityOutputType> outputTypes;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public String definition() {
        return this.definition;
    }

    public ActivityProperties withDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public List<ActivityParameterSet> parameterSets() {
        return this.parameterSets;
    }

    public ActivityProperties withParameterSets(List<ActivityParameterSet> parameterSets) {
        this.parameterSets = parameterSets;
        return this;
    }

    public List<ActivityOutputType> outputTypes() {
        return this.outputTypes;
    }

    public ActivityProperties withOutputTypes(List<ActivityOutputType> outputTypes) {
        this.outputTypes = outputTypes;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public ActivityProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ActivityProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ActivityProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.parameterSets() != null) {
            this.parameterSets().forEach(e -> e.validate());
        }
        if (this.outputTypes() != null) {
            this.outputTypes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("definition", this.definition);
        jsonWriter.writeArrayField("parameterSets", this.parameterSets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputTypes", this.outputTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ActivityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityProperties)jsonReader.readObject(reader -> {
            ActivityProperties deserializedActivityProperties = new ActivityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("definition".equals(fieldName)) {
                    deserializedActivityProperties.definition = reader.getString();
                    continue;
                }
                if ("parameterSets".equals(fieldName)) {
                    List parameterSets;
                    deserializedActivityProperties.parameterSets = parameterSets = reader.readArray(reader1 -> ActivityParameterSet.fromJson(reader1));
                    continue;
                }
                if ("outputTypes".equals(fieldName)) {
                    List outputTypes;
                    deserializedActivityProperties.outputTypes = outputTypes = reader.readArray(reader1 -> ActivityOutputType.fromJson(reader1));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedActivityProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedActivityProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedActivityProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityProperties;
        });
    }
}

