/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AgentRegistrationKeys;
import java.io.IOException;

public final class AgentRegistrationInner
implements JsonSerializable<AgentRegistrationInner> {
    private String dscMetaConfiguration;
    private String endpoint;
    private AgentRegistrationKeys keys;
    private String id;

    public String dscMetaConfiguration() {
        return this.dscMetaConfiguration;
    }

    public AgentRegistrationInner withDscMetaConfiguration(String dscMetaConfiguration) {
        this.dscMetaConfiguration = dscMetaConfiguration;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public AgentRegistrationInner withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AgentRegistrationKeys keys() {
        return this.keys;
    }

    public AgentRegistrationInner withKeys(AgentRegistrationKeys keys) {
        this.keys = keys;
        return this;
    }

    public String id() {
        return this.id;
    }

    public AgentRegistrationInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.keys() != null) {
            this.keys().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dscMetaConfiguration", this.dscMetaConfiguration);
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeJsonField("keys", (JsonSerializable)this.keys);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static AgentRegistrationInner fromJson(JsonReader jsonReader) throws IOException {
        return (AgentRegistrationInner)jsonReader.readObject(reader -> {
            AgentRegistrationInner deserializedAgentRegistrationInner = new AgentRegistrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dscMetaConfiguration".equals(fieldName)) {
                    deserializedAgentRegistrationInner.dscMetaConfiguration = reader.getString();
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedAgentRegistrationInner.endpoint = reader.getString();
                    continue;
                }
                if ("keys".equals(fieldName)) {
                    deserializedAgentRegistrationInner.keys = AgentRegistrationKeys.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedAgentRegistrationInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentRegistrationInner;
        });
    }
}

