/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.AutomationAccountProperties;
import com.azure.resourcemanager.automation.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.automation.models.AutomationAccountState;
import com.azure.resourcemanager.automation.models.EncryptionProperties;
import com.azure.resourcemanager.automation.models.Identity;
import com.azure.resourcemanager.automation.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AutomationAccountInner
extends Resource {
    private AutomationAccountProperties innerProperties;
    private String etag;
    private Identity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private AutomationAccountProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public AutomationAccountInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public AutomationAccountInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AutomationAccountInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AutomationAccountInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public AutomationAccountInner withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    public AutomationAccountInner withLastModifiedBy(String lastModifiedBy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withLastModifiedBy(lastModifiedBy);
        return this;
    }

    public AutomationAccountState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public AutomationAccountInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public AutomationAccountInner withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public AutomationAccountInner withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    public Boolean publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public AutomationAccountInner withPublicNetworkAccess(Boolean publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public AutomationAccountInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public String automationHybridServiceUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().automationHybridServiceUrl();
    }

    public AutomationAccountInner withAutomationHybridServiceUrl(String automationHybridServiceUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountProperties();
        }
        this.innerProperties().withAutomationHybridServiceUrl(automationHybridServiceUrl);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static AutomationAccountInner fromJson(JsonReader jsonReader) throws IOException {
        return (AutomationAccountInner)((Object)jsonReader.readObject(reader -> {
            AutomationAccountInner deserializedAutomationAccountInner = new AutomationAccountInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAutomationAccountInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutomationAccountInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAutomationAccountInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAutomationAccountInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAutomationAccountInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutomationAccountInner.innerProperties = AutomationAccountProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAutomationAccountInner.etag = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAutomationAccountInner.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAutomationAccountInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutomationAccountInner;
        }));
    }
}

