/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.automation.models.AutomationAccountState;
import com.azure.resourcemanager.automation.models.EncryptionProperties;
import com.azure.resourcemanager.automation.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AutomationAccountProperties
implements JsonSerializable<AutomationAccountProperties> {
    private Sku sku;
    private String lastModifiedBy;
    private AutomationAccountState state;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;
    private EncryptionProperties encryption;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private Boolean publicNetworkAccess;
    private Boolean disableLocalAuth;
    private String automationHybridServiceUrl;

    public Sku sku() {
        return this.sku;
    }

    public AutomationAccountProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public AutomationAccountProperties withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public AutomationAccountState state() {
        return this.state;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String description() {
        return this.description;
    }

    public AutomationAccountProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public AutomationAccountProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AutomationAccountProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public Boolean publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public AutomationAccountProperties withPublicNetworkAccess(Boolean publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public AutomationAccountProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public String automationHybridServiceUrl() {
        return this.automationHybridServiceUrl;
    }

    public AutomationAccountProperties withAutomationHybridServiceUrl(String automationHybridServiceUrl) {
        this.automationHybridServiceUrl = automationHybridServiceUrl;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("publicNetworkAccess", this.publicNetworkAccess);
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("automationHybridServiceUrl", this.automationHybridServiceUrl);
        return jsonWriter.writeEndObject();
    }

    public static AutomationAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutomationAccountProperties)jsonReader.readObject(reader -> {
            AutomationAccountProperties deserializedAutomationAccountProperties = new AutomationAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedAutomationAccountProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedAutomationAccountProperties.lastModifiedBy = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAutomationAccountProperties.state = AutomationAccountState.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedAutomationAccountProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedAutomationAccountProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAutomationAccountProperties.description = reader.getString();
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedAutomationAccountProperties.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedAutomationAccountProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedAutomationAccountProperties.publicNetworkAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedAutomationAccountProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("automationHybridServiceUrl".equals(fieldName)) {
                    deserializedAutomationAccountProperties.automationHybridServiceUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutomationAccountProperties;
        });
    }
}

