/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.EncryptionProperties;
import com.azure.resourcemanager.automation.models.Sku;
import java.io.IOException;

public final class AutomationAccountUpdateProperties
implements JsonSerializable<AutomationAccountUpdateProperties> {
    private Sku sku;
    private EncryptionProperties encryption;
    private Boolean publicNetworkAccess;
    private Boolean disableLocalAuth;

    public Sku sku() {
        return this.sku;
    }

    public AutomationAccountUpdateProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public AutomationAccountUpdateProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public AutomationAccountUpdateProperties withPublicNetworkAccess(Boolean publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public AutomationAccountUpdateProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeBooleanField("publicNetworkAccess", this.publicNetworkAccess);
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        return jsonWriter.writeEndObject();
    }

    public static AutomationAccountUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutomationAccountUpdateProperties)jsonReader.readObject(reader -> {
            AutomationAccountUpdateProperties deserializedAutomationAccountUpdateProperties = new AutomationAccountUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedAutomationAccountUpdateProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedAutomationAccountUpdateProperties.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedAutomationAccountUpdateProperties.publicNetworkAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedAutomationAccountUpdateProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutomationAccountUpdateProperties;
        });
    }
}

