/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CertificateCreateOrUpdateProperties
implements JsonSerializable<CertificateCreateOrUpdateProperties> {
    private String base64Value;
    private String description;
    private String thumbprint;
    private Boolean isExportable;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateCreateOrUpdateProperties.class);

    public String base64Value() {
        return this.base64Value;
    }

    public CertificateCreateOrUpdateProperties withBase64Value(String base64Value) {
        this.base64Value = base64Value;
        return this;
    }

    public String description() {
        return this.description;
    }

    public CertificateCreateOrUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public CertificateCreateOrUpdateProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public Boolean isExportable() {
        return this.isExportable;
    }

    public CertificateCreateOrUpdateProperties withIsExportable(Boolean isExportable) {
        this.isExportable = isExportable;
        return this;
    }

    public void validate() {
        if (this.base64Value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property base64Value in model CertificateCreateOrUpdateProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("base64Value", this.base64Value);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeBooleanField("isExportable", this.isExportable);
        return jsonWriter.writeEndObject();
    }

    public static CertificateCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            CertificateCreateOrUpdateProperties deserializedCertificateCreateOrUpdateProperties = new CertificateCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("base64Value".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.base64Value = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.description = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("isExportable".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.isExportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateCreateOrUpdateProperties;
        });
    }
}

