/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CertificateProperties
implements JsonSerializable<CertificateProperties> {
    private String thumbprint;
    private OffsetDateTime expiryTime;
    private Boolean isExportable;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public String thumbprint() {
        return this.thumbprint;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public Boolean isExportable() {
        return this.isExportable;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String description() {
        return this.description;
    }

    public CertificateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateProperties)jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedCertificateProperties.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isExportable".equals(fieldName)) {
                    deserializedCertificateProperties.isExportable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedCertificateProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedCertificateProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCertificateProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateProperties;
        });
    }
}

