/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ConnectionTypeAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class ConnectionCreateOrUpdateProperties
implements JsonSerializable<ConnectionCreateOrUpdateProperties> {
    private String description;
    private ConnectionTypeAssociationProperty connectionType;
    private Map<String, String> fieldDefinitionValues;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionCreateOrUpdateProperties.class);

    public String description() {
        return this.description;
    }

    public ConnectionCreateOrUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public ConnectionTypeAssociationProperty connectionType() {
        return this.connectionType;
    }

    public ConnectionCreateOrUpdateProperties withConnectionType(ConnectionTypeAssociationProperty connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public Map<String, String> fieldDefinitionValues() {
        return this.fieldDefinitionValues;
    }

    public ConnectionCreateOrUpdateProperties withFieldDefinitionValues(Map<String, String> fieldDefinitionValues) {
        this.fieldDefinitionValues = fieldDefinitionValues;
        return this;
    }

    public void validate() {
        if (this.connectionType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionType in model ConnectionCreateOrUpdateProperties"));
        }
        this.connectionType().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionType", (JsonSerializable)this.connectionType);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("fieldDefinitionValues", this.fieldDefinitionValues, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ConnectionCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            ConnectionCreateOrUpdateProperties deserializedConnectionCreateOrUpdateProperties = new ConnectionCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionType".equals(fieldName)) {
                    deserializedConnectionCreateOrUpdateProperties.connectionType = ConnectionTypeAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedConnectionCreateOrUpdateProperties.description = reader.getString();
                    continue;
                }
                if ("fieldDefinitionValues".equals(fieldName)) {
                    Map fieldDefinitionValues;
                    deserializedConnectionCreateOrUpdateProperties.fieldDefinitionValues = fieldDefinitionValues = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionCreateOrUpdateProperties;
        });
    }
}

