/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionProperties;
import com.azure.resourcemanager.automation.models.ConnectionTypeAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ConnectionInner
extends ProxyResource {
    private ConnectionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private ConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ConnectionTypeAssociationProperty connectionType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionType();
    }

    public ConnectionInner withConnectionType(ConnectionTypeAssociationProperty connectionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionProperties();
        }
        this.innerProperties().withConnectionType(connectionType);
        return this;
    }

    public Map<String, String> fieldDefinitionValues() {
        return this.innerProperties() == null ? null : this.innerProperties().fieldDefinitionValues();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ConnectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionInner)((Object)jsonReader.readObject(reader -> {
            ConnectionInner deserializedConnectionInner = new ConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnectionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectionInner.innerProperties = ConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionInner;
        }));
    }
}

