/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ConnectionTypeAssociationProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ConnectionProperties
implements JsonSerializable<ConnectionProperties> {
    private ConnectionTypeAssociationProperty connectionType;
    private Map<String, String> fieldDefinitionValues;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public ConnectionTypeAssociationProperty connectionType() {
        return this.connectionType;
    }

    public ConnectionProperties withConnectionType(ConnectionTypeAssociationProperty connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public Map<String, String> fieldDefinitionValues() {
        return this.fieldDefinitionValues;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String description() {
        return this.description;
    }

    public ConnectionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.connectionType() != null) {
            this.connectionType().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionType", (JsonSerializable)this.connectionType);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionProperties)jsonReader.readObject(reader -> {
            ConnectionProperties deserializedConnectionProperties = new ConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionType".equals(fieldName)) {
                    deserializedConnectionProperties.connectionType = ConnectionTypeAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("fieldDefinitionValues".equals(fieldName)) {
                    Map fieldDefinitionValues;
                    deserializedConnectionProperties.fieldDefinitionValues = fieldDefinitionValues = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedConnectionProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedConnectionProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedConnectionProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionProperties;
        });
    }
}

