/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.FieldDefinition;
import java.io.IOException;
import java.util.Map;

public final class ConnectionTypeCreateOrUpdateProperties
implements JsonSerializable<ConnectionTypeCreateOrUpdateProperties> {
    private Boolean isGlobal;
    private Map<String, FieldDefinition> fieldDefinitions;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionTypeCreateOrUpdateProperties.class);

    public Boolean isGlobal() {
        return this.isGlobal;
    }

    public ConnectionTypeCreateOrUpdateProperties withIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public Map<String, FieldDefinition> fieldDefinitions() {
        return this.fieldDefinitions;
    }

    public ConnectionTypeCreateOrUpdateProperties withFieldDefinitions(Map<String, FieldDefinition> fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
        return this;
    }

    public void validate() {
        if (this.fieldDefinitions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fieldDefinitions in model ConnectionTypeCreateOrUpdateProperties"));
        }
        this.fieldDefinitions().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("fieldDefinitions", this.fieldDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isGlobal", this.isGlobal);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionTypeCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionTypeCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            ConnectionTypeCreateOrUpdateProperties deserializedConnectionTypeCreateOrUpdateProperties = new ConnectionTypeCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldDefinitions".equals(fieldName)) {
                    Map fieldDefinitions;
                    deserializedConnectionTypeCreateOrUpdateProperties.fieldDefinitions = fieldDefinitions = reader.readMap(reader1 -> FieldDefinition.fromJson(reader1));
                    continue;
                }
                if ("isGlobal".equals(fieldName)) {
                    deserializedConnectionTypeCreateOrUpdateProperties.isGlobal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionTypeCreateOrUpdateProperties;
        });
    }
}

