/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionTypeProperties;
import com.azure.resourcemanager.automation.models.FieldDefinition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ConnectionTypeInner
implements JsonSerializable<ConnectionTypeInner> {
    private String id;
    private String name;
    private String type;
    private ConnectionTypeProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private ConnectionTypeProperties innerProperties() {
        return this.innerProperties;
    }

    public Boolean isGlobal() {
        return this.innerProperties() == null ? null : this.innerProperties().isGlobal();
    }

    public ConnectionTypeInner withIsGlobal(Boolean isGlobal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionTypeProperties();
        }
        this.innerProperties().withIsGlobal(isGlobal);
        return this;
    }

    public Map<String, FieldDefinition> fieldDefinitions() {
        return this.innerProperties() == null ? null : this.innerProperties().fieldDefinitions();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public ConnectionTypeInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionTypeProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ConnectionTypeInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionTypeProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionTypeInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionTypeInner)jsonReader.readObject(reader -> {
            ConnectionTypeInner deserializedConnectionTypeInner = new ConnectionTypeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectionTypeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectionTypeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnectionTypeInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectionTypeInner.innerProperties = ConnectionTypeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionTypeInner;
        });
    }
}

