/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.FieldDefinition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class ConnectionTypeProperties
implements JsonSerializable<ConnectionTypeProperties> {
    private Boolean isGlobal;
    private Map<String, FieldDefinition> fieldDefinitions;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public Boolean isGlobal() {
        return this.isGlobal;
    }

    public ConnectionTypeProperties withIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    public Map<String, FieldDefinition> fieldDefinitions() {
        return this.fieldDefinitions;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ConnectionTypeProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ConnectionTypeProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.fieldDefinitions() != null) {
            this.fieldDefinitions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isGlobal", this.isGlobal);
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionTypeProperties)jsonReader.readObject(reader -> {
            ConnectionTypeProperties deserializedConnectionTypeProperties = new ConnectionTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isGlobal".equals(fieldName)) {
                    deserializedConnectionTypeProperties.isGlobal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("fieldDefinitions".equals(fieldName)) {
                    Map fieldDefinitions;
                    deserializedConnectionTypeProperties.fieldDefinitions = fieldDefinitions = reader.readMap(reader1 -> FieldDefinition.fromJson(reader1));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedConnectionTypeProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedConnectionTypeProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedConnectionTypeProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionTypeProperties;
        });
    }
}

