/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CredentialCreateOrUpdateProperties
implements JsonSerializable<CredentialCreateOrUpdateProperties> {
    private String username;
    private String password;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(CredentialCreateOrUpdateProperties.class);

    public String username() {
        return this.username;
    }

    public CredentialCreateOrUpdateProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CredentialCreateOrUpdateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String description() {
        return this.description;
    }

    public CredentialCreateOrUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model CredentialCreateOrUpdateProperties"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model CredentialCreateOrUpdateProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static CredentialCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            CredentialCreateOrUpdateProperties deserializedCredentialCreateOrUpdateProperties = new CredentialCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedCredentialCreateOrUpdateProperties.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCredentialCreateOrUpdateProperties.password = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCredentialCreateOrUpdateProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialCreateOrUpdateProperties;
        });
    }
}

