/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.CredentialProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CredentialInner
extends ProxyResource {
    private CredentialProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private CredentialProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public CredentialInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialInner)((Object)jsonReader.readObject(reader -> {
            CredentialInner deserializedCredentialInner = new CredentialInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCredentialInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCredentialInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCredentialInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCredentialInner.innerProperties = CredentialProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialInner;
        }));
    }
}

