/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CredentialProperties
implements JsonSerializable<CredentialProperties> {
    private String username;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public String username() {
        return this.username;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String description() {
        return this.description;
    }

    public CredentialProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static CredentialProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialProperties)jsonReader.readObject(reader -> {
            CredentialProperties deserializedCredentialProperties = new CredentialProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedCredentialProperties.username = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedCredentialProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedCredentialProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCredentialProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialProperties;
        });
    }
}

