/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class DscCompilationJobCreateProperties
implements JsonSerializable<DscCompilationJobCreateProperties> {
    private DscConfigurationAssociationProperty configuration;
    private Map<String, String> parameters;
    private Boolean incrementNodeConfigurationBuild;
    private static final ClientLogger LOGGER = new ClientLogger(DscCompilationJobCreateProperties.class);

    public DscConfigurationAssociationProperty configuration() {
        return this.configuration;
    }

    public DscCompilationJobCreateProperties withConfiguration(DscConfigurationAssociationProperty configuration) {
        this.configuration = configuration;
        return this;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public DscCompilationJobCreateProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean incrementNodeConfigurationBuild() {
        return this.incrementNodeConfigurationBuild;
    }

    public DscCompilationJobCreateProperties withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        this.incrementNodeConfigurationBuild = incrementNodeConfigurationBuild;
        return this;
    }

    public void validate() {
        if (this.configuration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property configuration in model DscCompilationJobCreateProperties"));
        }
        this.configuration().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("incrementNodeConfigurationBuild", this.incrementNodeConfigurationBuild);
        return jsonWriter.writeEndObject();
    }

    public static DscCompilationJobCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscCompilationJobCreateProperties)jsonReader.readObject(reader -> {
            DscCompilationJobCreateProperties deserializedDscCompilationJobCreateProperties = new DscCompilationJobCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configuration".equals(fieldName)) {
                    deserializedDscCompilationJobCreateProperties.configuration = DscConfigurationAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDscCompilationJobCreateProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("incrementNodeConfigurationBuild".equals(fieldName)) {
                    deserializedDscCompilationJobCreateProperties.incrementNodeConfigurationBuild = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscCompilationJobCreateProperties;
        });
    }
}

