/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscCompilationJobProperties;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class DscCompilationJobInner
extends ProxyResource {
    private DscCompilationJobProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DscCompilationJobProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DscConfigurationAssociationProperty configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public DscCompilationJobInner withConfiguration(DscConfigurationAssociationProperty configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public String startedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().startedBy();
    }

    public UUID jobId() {
        return this.innerProperties() == null ? null : this.innerProperties().jobId();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public JobProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DscCompilationJobInner withProvisioningState(JobProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public DscCompilationJobInner withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public JobStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public DscCompilationJobInner withStatus(JobStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public String statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    public DscCompilationJobInner withStatusDetails(String statusDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobProperties();
        }
        this.innerProperties().withStatusDetails(statusDetails);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public String exception() {
        return this.innerProperties() == null ? null : this.innerProperties().exception();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public OffsetDateTime lastStatusModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastStatusModifiedTime();
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public DscCompilationJobInner withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DscCompilationJobInner fromJson(JsonReader jsonReader) throws IOException {
        return (DscCompilationJobInner)((Object)jsonReader.readObject(reader -> {
            DscCompilationJobInner deserializedDscCompilationJobInner = new DscCompilationJobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDscCompilationJobInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscCompilationJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDscCompilationJobInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDscCompilationJobInner.innerProperties = DscCompilationJobProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscCompilationJobInner;
        }));
    }
}

