/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class DscCompilationJobProperties
implements JsonSerializable<DscCompilationJobProperties> {
    private DscConfigurationAssociationProperty configuration;
    private String startedBy;
    private UUID jobId;
    private OffsetDateTime creationTime;
    private JobProvisioningState provisioningState;
    private String runOn;
    private JobStatus status;
    private String statusDetails;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String exception;
    private OffsetDateTime lastModifiedTime;
    private OffsetDateTime lastStatusModifiedTime;
    private Map<String, String> parameters;

    public DscConfigurationAssociationProperty configuration() {
        return this.configuration;
    }

    public DscCompilationJobProperties withConfiguration(DscConfigurationAssociationProperty configuration) {
        this.configuration = configuration;
        return this;
    }

    public String startedBy() {
        return this.startedBy;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public JobProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DscCompilationJobProperties withProvisioningState(JobProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String runOn() {
        return this.runOn;
    }

    public DscCompilationJobProperties withRunOn(String runOn) {
        this.runOn = runOn;
        return this;
    }

    public JobStatus status() {
        return this.status;
    }

    public DscCompilationJobProperties withStatus(JobStatus status) {
        this.status = status;
        return this;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public DscCompilationJobProperties withStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public String exception() {
        return this.exception;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public OffsetDateTime lastStatusModifiedTime() {
        return this.lastStatusModifiedTime;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public DscCompilationJobProperties withParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("runOn", this.runOn);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DscCompilationJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscCompilationJobProperties)jsonReader.readObject(reader -> {
            DscCompilationJobProperties deserializedDscCompilationJobProperties = new DscCompilationJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configuration".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.configuration = DscConfigurationAssociationProperty.fromJson(reader);
                    continue;
                }
                if ("startedBy".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.startedBy = reader.getString();
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.jobId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.provisioningState = JobProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("runOn".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.runOn = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.status = JobStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exception".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.exception = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastStatusModifiedTime".equals(fieldName)) {
                    deserializedDscCompilationJobProperties.lastStatusModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDscCompilationJobProperties.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscCompilationJobProperties;
        });
    }
}

