/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import java.io.IOException;
import java.util.Map;

public final class DscConfigurationCreateOrUpdateProperties
implements JsonSerializable<DscConfigurationCreateOrUpdateProperties> {
    private Boolean logVerbose;
    private Boolean logProgress;
    private ContentSource source;
    private Map<String, DscConfigurationParameter> parameters;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(DscConfigurationCreateOrUpdateProperties.class);

    public Boolean logVerbose() {
        return this.logVerbose;
    }

    public DscConfigurationCreateOrUpdateProperties withLogVerbose(Boolean logVerbose) {
        this.logVerbose = logVerbose;
        return this;
    }

    public Boolean logProgress() {
        return this.logProgress;
    }

    public DscConfigurationCreateOrUpdateProperties withLogProgress(Boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    public ContentSource source() {
        return this.source;
    }

    public DscConfigurationCreateOrUpdateProperties withSource(ContentSource source) {
        this.source = source;
        return this;
    }

    public Map<String, DscConfigurationParameter> parameters() {
        return this.parameters;
    }

    public DscConfigurationCreateOrUpdateProperties withParameters(Map<String, DscConfigurationParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String description() {
        return this.description;
    }

    public DscConfigurationCreateOrUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model DscConfigurationCreateOrUpdateProperties"));
        }
        this.source().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeBooleanField("logVerbose", this.logVerbose);
        jsonWriter.writeBooleanField("logProgress", this.logProgress);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static DscConfigurationCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DscConfigurationCreateOrUpdateProperties)jsonReader.readObject(reader -> {
            DscConfigurationCreateOrUpdateProperties deserializedDscConfigurationCreateOrUpdateProperties = new DscConfigurationCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateProperties.source = ContentSource.fromJson(reader);
                    continue;
                }
                if ("logVerbose".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateProperties.logVerbose = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("logProgress".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateProperties.logProgress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDscConfigurationCreateOrUpdateProperties.parameters = parameters = reader.readMap(reader1 -> DscConfigurationParameter.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscConfigurationCreateOrUpdateProperties;
        });
    }
}

