/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationProperties;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import com.azure.resourcemanager.automation.models.DscConfigurationProvisioningState;
import com.azure.resourcemanager.automation.models.DscConfigurationState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class DscConfigurationInner
extends Resource {
    private DscConfigurationProperties innerProperties;
    private String etag;
    private String type;
    private String name;
    private String id;

    private DscConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public DscConfigurationInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DscConfigurationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DscConfigurationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public DscConfigurationProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DscConfigurationInner withProvisioningState(DscConfigurationProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    public Integer jobCount() {
        return this.innerProperties() == null ? null : this.innerProperties().jobCount();
    }

    public DscConfigurationInner withJobCount(Integer jobCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withJobCount(jobCount);
        return this;
    }

    public Map<String, DscConfigurationParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public DscConfigurationInner withParameters(Map<String, DscConfigurationParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public ContentSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public DscConfigurationInner withSource(ContentSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public DscConfigurationState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public DscConfigurationInner withState(DscConfigurationState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public Boolean logVerbose() {
        return this.innerProperties() == null ? null : this.innerProperties().logVerbose();
    }

    public DscConfigurationInner withLogVerbose(Boolean logVerbose) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withLogVerbose(logVerbose);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public DscConfigurationInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public DscConfigurationInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    public Integer nodeConfigurationCount() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeConfigurationCount();
    }

    public DscConfigurationInner withNodeConfigurationCount(Integer nodeConfigurationCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withNodeConfigurationCount(nodeConfigurationCount);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public DscConfigurationInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static DscConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (DscConfigurationInner)((Object)jsonReader.readObject(reader -> {
            DscConfigurationInner deserializedDscConfigurationInner = new DscConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDscConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDscConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDscConfigurationInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDscConfigurationInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDscConfigurationInner.innerProperties = DscConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDscConfigurationInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscConfigurationInner;
        }));
    }
}

